<?php
function icoswitch_overrides_tax_ico_types() {
    $tax = get_taxonomy( 'mt-listing-category' ); // returns an object

	$convert_taxonomy_status = get_option('icoswitch_convert_taxonomies');
	$convert_ico_types_taxonomy_status = get_option('icoswitch_convert_taxonomies_ico_types');
	$label_singular = get_option('icoswitch_new_ico_types_title_singular');
	$label_plural = get_option('icoswitch_new_ico_types_title_plural');
	$slug = get_option('icoswitch_new_ico_types_slug');

	if ($convert_taxonomy_status == 'yes' && $convert_ico_types_taxonomy_status == 'yes') {
    	$tax->show_admin_column = true;

    	$tax->labels->name = _x( $label_singular, $label_plural, 'mtlisitings' );
    	$tax->labels->singular_name = _x( $label_singular, $label_plural, 'mtlisitings' );
    	$tax->labels->menu_name = __( $label_plural, 'mtlisitings' );

    	$tax->rewrite['slug'] = $slug;
    	$tax->rewrite['with_front'] = false;
	}
    
    // re-register the taxonomy
    register_taxonomy( 'mt-listing-category', 'mt_listing', (array) $tax );
}
add_action( 'init', 'icoswitch_overrides_tax_ico_types', 11 );



function icoswitch_overrides_tax_categories() {
    $tax = get_taxonomy( 'mt-listing-category2' ); // returns an object

	$convert_taxonomy_status = get_option('icoswitch_convert_taxonomies');
	$convert_cats_taxonomy_status = get_option('icoswitch_convert_taxonomies_cats');
	$label_singular = get_option('icoswitch_new_cats_title_singular');
	$label_plural = get_option('icoswitch_new_cats_title_plural');
	$slug = get_option('icoswitch_new_cats_slug');


	if ($convert_taxonomy_status == 'yes' && $convert_cats_taxonomy_status == 'yes') {
    	$tax->show_admin_column = true;

    	$tax->labels->name = _x( $label_singular, $label_plural, 'mtlisitings' );
    	$tax->labels->singular_name = _x( $label_singular, $label_plural, 'mtlisitings' );
    	$tax->labels->menu_name = __( $label_plural, 'mtlisitings' );

    	$tax->rewrite['slug'] = $slug;
    	$tax->rewrite['with_front'] = false;
	}
    
    // re-register the taxonomy
    register_taxonomy( 'mt-listing-category2', 'mt_listing', (array) $tax );
}
add_action( 'init', 'icoswitch_overrides_tax_categories', 11 );