<?php


function icoswitch_load_textdomain(){
    $domain = 'icoswitch';
    load_plugin_textdomain( $domain, FALSE, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
}
add_action( 'plugins_loaded', 'icoswitch_load_textdomain' );

function icoswitch_is_cpt_title_singular() {
    if(get_option('icoswitch_new_cpt_title_singular') != ''){
        return get_option('icoswitch_new_cpt_title_singular');
    }
}
function icoswitch_is_cpt_title_plural() {
    if(get_option('icoswitch_new_cpt_title_plural') != ''){
        return get_option('icoswitch_new_cpt_title_plural');
    }
}

function icoswitch_enqueue_admin_scripts( $hook ) {
    wp_register_style( 'icoswitch-admin-style',  get_stylesheet_directory_uri() . '/inc/ico-switcher/css/icoswitcher-admin.css' );
    wp_enqueue_style( 'icoswitch-admin-style' );
    // wp_enqueue_script( 'icoswitch-scripts-admin', plugin_dir_url( __FILE__ ) . 'js/icoswitch-custom-admin.js', array(), '1.0.0', true );
    wp_enqueue_script( 'icoswitch-scripts-admin', get_stylesheet_directory_uri() . '/inc/ico-switcher/js/icoswitch-custom-admin.js', array(), '1.0.0', true );
}
add_action('admin_enqueue_scripts', 'icoswitch_enqueue_admin_scripts');

// require_once('inc/post-types.php');
// require_once('inc/metaboxes.php');
// require_once('inc/shortcodes.php');

function icoswitch_settings_admin_page() {
    include_once('admin/views/icoswitch-settings.php');
}

require_once('admin/views/cpt.overrides.php');
require_once('admin/views/taxonomy.overrides.php');


function icoswitch_add_menu_pages() {
    add_submenu_page(
        'edit.php?post_type=mt_listing',
        esc_html__('MT Switcher'),
        esc_html__('MT Switcher'),
        'manage_options',
        'icoswitch_settings',
        'icoswitch_settings_admin_page'
    );
}
add_action( 'admin_menu', 'icoswitch_add_menu_pages' );

function icoswitch_render_yesno($args) {
    echo '<select id="'. $args['name'] .'" name="'. $args['name'] .'">';
    echo '<option value="no" ' . ($args['value'] == 'no' ? 'selected' : '') . '>' . __('No') . '</option>';
    echo '<option value="yes" ' . ($args['value'] == 'yes' ? 'selected' : '') . '>' . __('Yes') . '</option>';
    echo '</select>';
}
function icoswitch_render_text($args) {
    echo '<input type="text" class="'. $args['class'] .'" id="'. $args['name'] .'" name="'. $args['name'] .'" placeholder="'. $args['placeholder'] .'" value="'. $args['value'] .'" class="" />';
}

function icoswitch_register_settings() {
    // cpt
    register_setting( 'icoswitch_settings', 'icoswitch_new_cpt_title_singular');
    register_setting( 'icoswitch_settings', 'icoswitch_new_cpt_title_plural');
    register_setting( 'icoswitch_settings', 'icoswitch_new_cpt_slug');
    // tax ico types
    register_setting( 'icoswitch_settings', 'icoswitch_convert_taxonomies');
    register_setting( 'icoswitch_settings', 'icoswitch_convert_taxonomies_ico_types');
    register_setting( 'icoswitch_settings', 'icoswitch_new_ico_types_title_singular');
    register_setting( 'icoswitch_settings', 'icoswitch_new_ico_types_title_plural');
    register_setting( 'icoswitch_settings', 'icoswitch_new_ico_types_slug');
    // tax category
    register_setting( 'icoswitch_settings', 'icoswitch_convert_taxonomies_cats');
    register_setting( 'icoswitch_settings', 'icoswitch_new_cats_title_singular');
    register_setting( 'icoswitch_settings', 'icoswitch_new_cats_title_plural');
    register_setting( 'icoswitch_settings', 'icoswitch_new_cats_slug');
    // shortcodes
    register_setting( 'icoswitch_settings', 'icoswitch_convert_shortcodes');

    add_settings_section(
        'icoswitch_settings',
        __('New CPT Details:', 'icoswitch'),
        null,
        'icoswitch_settings'
    );

    // CPT
    add_settings_field(
        'icoswitch_new_cpt_title_singular',
        __('CPT Title (Singular)', 'icoswitch'),
        'icoswitch_render_text',
        'icoswitch_settings',
        'icoswitch_settings',
        [
            'name' => 'icoswitch_new_cpt_title_singular',
            'class' => '',
            'placeholder' => 'Listing',
            'value' => !empty($_POST['icoswitch_new_cpt_title_singular']) ? $_POST['icoswitch_new_cpt_title_singular'] : get_option('icoswitch_new_cpt_title_singular')
        ]
    );
    add_settings_field(
        'icoswitch_new_cpt_title_plural',
        __('CPT Title (Plural)', 'icoswitch'),
        'icoswitch_render_text',
        'icoswitch_settings',
        'icoswitch_settings',
        [
            'name' => 'icoswitch_new_cpt_title_plural',
            'class' => '',
            'placeholder' => 'Listings',
            'value' => !empty($_POST['icoswitch_new_cpt_title_plural']) ? $_POST['icoswitch_new_cpt_title_plural'] : get_option('icoswitch_new_cpt_title_plural')
        ]
    );
    add_settings_field(
        'icoswitch_new_cpt_slug',
        __('CPT Slug', 'icoswitch'),
        'icoswitch_render_text',
        'icoswitch_settings',
        'icoswitch_settings',
        [
            'name' => 'icoswitch_new_cpt_slug',
            'class' => '',
            'placeholder' => 'listing',
            'value' => !empty($_POST['icoswitch_new_cpt_slug']) ? $_POST['icoswitch_new_cpt_slug'] : get_option('icoswitch_new_cpt_slug')
        ]
    );


    // TAXONOMIES
    add_settings_field(
        'icoswitch_convert_taxonomies',
        __('Convert Taxonomies (ICO Types/Categories)?', 'icoswitch'),
        'icoswitch_render_yesno',
        'icoswitch_settings',
        'icoswitch_settings',
        [
            'name' => 'icoswitch_convert_taxonomies',
            'value' => !empty($_POST['icoswitch_convert_taxonomies']) ? $_POST['icoswitch_convert_taxonomies'] : get_option('icoswitch_convert_taxonomies')
        ]
    );
    // ICO TYPES
    add_settings_field(
        'icoswitch_convert_taxonomies_ico_types',
        __('Convert ICO Types taxonomy?', 'icoswitch'),
        'icoswitch_render_yesno',
        'icoswitch_settings',
        'icoswitch_settings',
        [
            'name' => 'icoswitch_convert_taxonomies_ico_types',
            'class' => 'is_hidden icoswitch_ico_types_tax',
            'value' => !empty($_POST['icoswitch_convert_taxonomies_ico_types']) ? $_POST['icoswitch_convert_taxonomies_ico_types'] : get_option('icoswitch_convert_taxonomies_ico_types')
        ]
    );
    add_settings_field(
        'icoswitch_new_ico_types_title_singular',
        __('"ICO Types" new title (singular)', 'icoswitch'),
        'icoswitch_render_text',
        'icoswitch_settings',
        'icoswitch_settings',
        [
            'name' => 'icoswitch_new_ico_types_title_singular',
            'class' => 'is_hidden icoswitch_tax1',
            'placeholder' => 'ICO Types',
            'value' => !empty($_POST['icoswitch_new_ico_types_title_singular']) ? $_POST['icoswitch_new_ico_types_title_singular'] : get_option('icoswitch_new_ico_types_title_singular')
        ]
    );
    add_settings_field(
        'icoswitch_new_ico_types_title_plural',
        __('"ICO Types" new title (plural)', 'icoswitch'),
        'icoswitch_render_text',
        'icoswitch_settings',
        'icoswitch_settings',
        [
            'name' => 'icoswitch_new_ico_types_title_plural',
            'class' => 'is_hidden icoswitch_tax1',
            'placeholder' => 'ICO Types',
            'value' => !empty($_POST['icoswitch_new_ico_types_title_plural']) ? $_POST['icoswitch_new_ico_types_title_plural'] : get_option('icoswitch_new_ico_types_title_plural')
        ]
    );
    add_settings_field(
        'icoswitch_new_ico_types_slug',
        __('"ICO Types" new slug', 'icoswitch'),
        'icoswitch_render_text',
        'icoswitch_settings',
        'icoswitch_settings',
        [
            'name' => 'icoswitch_new_ico_types_slug',
            'class' => 'is_hidden icoswitch_tax1',
            'placeholder' => 'ico-drops icoswitch_tax1',
            'value' => !empty($_POST['icoswitch_new_ico_types_slug']) ? $_POST['icoswitch_new_ico_types_slug'] : get_option('icoswitch_new_ico_types_slug')
        ]
    );
    // Categories
    add_settings_field(
        'icoswitch_convert_taxonomies_cats',
        __('Convert the "Categories" taxonomy?', 'icoswitch'),
        'icoswitch_render_yesno',
        'icoswitch_settings',
        'icoswitch_settings',
        [
            'name' => 'icoswitch_convert_taxonomies_cats',
            'class' => 'is_hidden icoswitch_cats_tax',
            'value' => !empty($_POST['icoswitch_convert_taxonomies_cats']) ? $_POST['icoswitch_convert_taxonomies_cats'] : get_option('icoswitch_convert_taxonomies_cats')
        ]
    );
    add_settings_field(
        'icoswitch_new_cats_title_singular',
        __('"Categories" new title (singular)', 'icoswitch'),
        'icoswitch_render_text',
        'icoswitch_settings',
        'icoswitch_settings',
        [
            'name' => 'icoswitch_new_cats_title_singular',
            'class' => 'is_hidden icoswitch_tax2',
            'placeholder' => 'Categories',
            'value' => !empty($_POST['icoswitch_new_cats_title_singular']) ? $_POST['icoswitch_new_cats_title_singular'] : get_option('icoswitch_new_cats_title_singular')
        ]
    );
    add_settings_field(
        'icoswitch_new_cats_title_plural',
        __('"Categories" new title (plural)', 'icoswitch'),
        'icoswitch_render_text',
        'icoswitch_settings',
        'icoswitch_settings',
        [
            'name' => 'icoswitch_new_cats_title_plural',
            'class' => 'is_hidden icoswitch_tax2',
            'placeholder' => 'Categories',
            'value' => !empty($_POST['icoswitch_new_cats_title_plural']) ? $_POST['icoswitch_new_cats_title_plural'] : get_option('icoswitch_new_cats_title_plural')
        ]
    );
    add_settings_field(
        'icoswitch_new_cats_slug',
        __('"Categories" new slug', 'icoswitch'),
        'icoswitch_render_text',
        'icoswitch_settings',
        'icoswitch_settings',
        [
            'name' => 'icoswitch_new_cats_slug',
            'class' => 'is_hidden icoswitch_tax2',
            'placeholder' => 'ico-drops',
            'value' => !empty($_POST['icoswitch_new_cats_slug']) ? $_POST['icoswitch_new_cats_slug'] : get_option('icoswitch_new_cats_slug')
        ]
    );

    // SHORTCODES
    add_settings_field(
        'icoswitch_convert_shortcodes',
        __('Convert Shortcodes?', 'icoswitch'),
        'icoswitch_render_yesno',
        'icoswitch_settings',
        'icoswitch_settings',
        [
            'name' => 'icoswitch_convert_shortcodes',
            'value' => !empty($_POST['icoswitch_convert_shortcodes']) ? $_POST['icoswitch_convert_shortcodes'] : get_option('icoswitch_convert_shortcodes')
        ]
    );

}
add_action( 'admin_init', 'icoswitch_register_settings');
