<?php 
if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
    if (function_exists('mtlisitings_framework')) {
        if ( is_user_logged_in() == false && get_permalink() == numismatico_redux('mt_listings_submit_ico_page')) {
            if (class_exists('WooCommerce')) {
                if ( wp_redirect( get_permalink( get_option('woocommerce_myaccount_page_id') ) ) ) {
                    exit;
                }
            }else{
                if ( wp_login_url() ) {
                    exit;
                }
            }
        }
    }
} ?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php esc_attr(bloginfo( 'charset' )); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) { ?>
        <link rel="shortcut icon" href="<?php echo esc_url(numismatico_redux('mt_favicon', 'url')); ?>">
    <?php } ?>

    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php 
if ( function_exists( 'wp_body_open' ) ) {
	wp_body_open();
}
?>


    <?php /* VARS */ ?>
    <?php 
    $below_slider_headers = array('header5', 'header6', 'header7', 'header8');
    $normal_headers = array('header1', 'header2', 'header3', 'header4');
    $custom_header_options_status = get_post_meta( get_the_ID(), 'smartowl_custom_header_options_status', true );
    $header_custom_variant = get_post_meta( get_the_ID(), 'smartowl_header_custom_variant', true );
    $header_layout = numismatico_redux('mt_header_layout');
    if (isset($custom_header_options_status) && $custom_header_options_status == 'yes') {
        $header_layout = $header_custom_variant;
    }
    ?>

    <?php if (!is_user_logged_in()) { ?>
        <?php if (!in_array('login-register-page', get_body_class())) { ?>
            <div class="modeltheme-modal" id="modal-log-in">
                <div class="modeltheme-content" id="login-modal-content">
                    <h3 class="relative">
                        <?php echo esc_html__('Login to Your Account','numismatico'); ?>
                    </h3>
                    <div class="modal-content row">
                        <div class="col-md-12">
                            <?php wp_login_form(); ?>
                                
                            <?php if (  get_option('users_can_register')) { ?>
                                <a class="btn btn-register" id="register-modal"><?php echo esc_html__('Register','numismatico'); ?></a>
                            <?php } else { ?>
                                <p class="um-notice err text-center"><?php echo esc_html__('Registration is currently disabled','numismatico'); ?></p>
                            <?php } ?>
                            <?php if (function_exists('yith_ywsl_constructor')) { ?>
                                <?php echo do_shortcode("[yith_wc_social_login]"); ?>
                            <?php } ?>
                            <p class="woocommerce-LostPassword lost_password">
                                <a href="<?php echo wp_lostpassword_url(); ?>"><?php echo esc_html__('Lost your password?','numismatico'); ?></a>
                            </p>
                        </div>
                    </div>
                </div>
                <div class="modeltheme-content" id="signup-modal-content">
                    <h3 class="relative">
                        <?php echo esc_html__('Personal Details','numismatico'); ?>
                    </h3>
                    <div class="modal-content row">
                        <div class="col-md-12">

                            <?php if ( class_exists( 'WooCommerce' ) ) { ?>
                                <?php if ( get_option( 'woocommerce_enable_myaccount_registration' ) === 'yes' ) { ?>
                                    <div class="u-column2 col-2">
                                        <form method="post" class="woocommerce-form woocommerce-form-register register">
                                            <?php do_action( 'woocommerce_register_form_start' ); ?>
                                            <?php if ( 'no' === get_option( 'woocommerce_registration_generate_username' ) ) : ?>
                                                <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
                                                    <input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="username" id="reg_username" autocomplete="username" value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" placeholder="<?php esc_attr_e( 'Username', 'numismatico' ); ?>" />
                                                </p>
                                            <?php endif; ?>
                                            <p class="form-row form-row-first">
                                                <input type="text" class="input-text" name="billing_first_name" id="billing_first_name" value="<?php if (!empty($_POST['billing_first_name'])) echo esc_attr($_POST['billing_first_name']); ?>" placeholder="<?php esc_attr_e( 'First name', 'numismatico' ); ?>" />
                                            </p>
                                            <p class="form-row form-row-last">
                                                <input type="text" class="input-text" name="billing_last_name" id="billing_last_name" value="<?php if (!empty($_POST['billing_last_name'])) echo esc_attr($_POST['billing_last_name']); ?>" placeholder="<?php esc_attr_e( 'Last name', 'numismatico' ); ?>" />
                                            </p>
                                            <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
                                                <input type="email" class="woocommerce-Input woocommerce-Input--text input-text" name="email" id="reg_email" autocomplete="email" value="<?php echo ( ! empty( $_POST['email'] ) ) ? esc_attr( wp_unslash( $_POST['email'] ) ) : ''; ?>" placeholder="<?php esc_attr_e( 'Email address', 'numismatico' ); ?>" />
                                            </p>
                                            <?php if ( 'no' === get_option( 'woocommerce_registration_generate_password' ) ) : ?>
                                                <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
                                                    <input type="password" class="woocommerce-Input woocommerce-Input--text input-text" name="password" id="reg_password" autocomplete="new-password" placeholder="Password" />
                                                </p>
                                            <?php endif; ?>
                                            <?php do_action( 'woocommerce_register_form' ); ?>
                                            <p class="woocommerce-FormRow form-row">
                                                <?php wp_nonce_field( 'woocommerce-register', 'woocommerce-register-nonce' ); ?>
                                                <button type="submit" class="woocommerce-Button button" name="register" value="<?php esc_attr_e( 'Register', 'numismatico' ); ?>"><?php esc_html_e( 'Register', 'numismatico' ); ?></button>
                                            </p>
                                            <?php do_action( 'woocommerce_register_form_end' ); ?>
                                        </form>
                                    </div>
                                <?php } ?>
                            <?php } ?>

                        </div>
                    </div>            
                </div>
            </div>
        <?php } ?>
    <?php } ?>

    <div class="modeltheme-overlay"></div>
    
    <?php /* SEARCH BLOCK */ ?>
    <?php if(numismatico_redux('mt_header_is_search') == true){ ?>
        <!-- Fixed Search Form -->
        <div class="fixed-search-overlay">
            <!-- Close Sidebar Menu + Close Overlay -->
            <i class="icon-close icons"></i>
            <!-- INSIDE SEARCH OVERLAY -->
            <div class="fixed-search-inside">
                <div class="modeltheme-search">
                    <form method="GET" action="<?php echo esc_url(home_url('/')); ?>">
                        <input class="search-input" placeholder="<?php echo esc_attr__('Enter search term...', 'numismatico'); ?>" type="search" value="" name="s" id="search" />
                        <i class="fa fa-search"></i>
                        <input type="hidden" name="post_type" value="post" />
                    </form>
                </div>
            </div>
        </div>
    <?php } ?>


    <?php /* BURGER MENU */ ?>
    <?php if(numismatico_redux('mt_header_fixed_sidebar_menu_status') == true){ ?>
        <!-- Fixed Sidebar Overlay -->
        <div class="fixed-sidebar-menu-overlay"></div>
        <!-- Fixed Sidebar Menu -->
        <div class="relative fixed-sidebar-menu-holder header7">
            <div class="fixed-sidebar-menu">
                <!-- Close Sidebar Menu + Close Overlay -->
                <i class="icon-close icons"></i>
                <!-- Sidebar Menu Holder -->
                <div class="header7 sidebar-content">
                    <!-- RIGHT SIDE -->
                    <div class="left-side">
                        <?php if ( class_exists( 'ReduxFrameworkPlugin' ) ) { ?>
                          <?php if(numismatico_redux('mt_logo','url')){ ?>
                            <div class="logo">
                                <a href="<?php echo esc_url(get_site_url()); ?>">
                                    <img src="<?php echo esc_url(get_template_directory_uri().'/images/logo_black.png'); ?>" alt="<?php echo esc_attr(get_bloginfo()); ?>" />
                                </a>
                            </div>
                          <?php }else{ ?>
                            <div class="logo no-logo">
                                <a href="<?php echo esc_url(get_site_url()); ?>">
                                  <?php echo esc_html(get_bloginfo()); ?>
                                </a>
                            </div>
                          <?php } ?>
                        <?php }else{ ?>
                          <div class="logo no-logo">
                              <a href="<?php echo esc_url(get_site_url()); ?>">
                                <?php echo esc_html(get_bloginfo()); ?>
                              </a>
                          </div>
                        <?php } ?>
                        <?php if (is_active_sidebar( numismatico_redux('mt_header_fixed_sidebar') )) {
                            dynamic_sidebar( numismatico_redux('mt_header_fixed_sidebar') ); 
                        } ?>
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>


    <!-- PAGE #page -->
    <div id="page" class="hfeed site">
        <?php
            $page_slider = get_post_meta( get_the_ID(), 'select_revslider_shortcode', true );
            if (in_array($header_layout, $below_slider_headers)){
                // Revolution slider
                if (!empty($page_slider)) {
                    echo '<div class="theme_header_slider">';
                    echo do_shortcode('[rev_slider '.esc_attr($page_slider).']');
                    echo '</div>';
                }

                // Header template variant
                echo wp_kses_post(numismatico_current_header_template());
            }elseif (in_array($header_layout, $normal_headers)){
                // Header template variant
                echo wp_kses_post(numismatico_current_header_template());
                // Revolution slider
                if (!empty($page_slider)) {
                    echo '<div class="theme_header_slider">';
                    echo do_shortcode('[rev_slider '.esc_attr($page_slider).']');
                    echo '</div>';
                }
            }else{
                echo wp_kses_post(numismatico_current_header_template());
            }