<?php
/**
 * The template for displaying search results.
 *
 */

get_header(); 

$class_row = "col-md-8";
$sidebar = 'sidebar-1';
if ( class_exists( 'ReduxFrameworkPlugin' ) && function_exists('mtlistings_framework') ) {
    if ( numismatico_redux('mt_listings_layout') == 'mt_listings_fullwidth' ) {
        $class_row = "col-md-12";
    }elseif ( numismatico_redux('mt_listings_layout') == 'mt_listings_right_sidebar' or numismatico_redux('mt_listings_layout') == 'mt_listings_left_sidebar') {
        $class_row = "col-md-8";
    }
    $sidebar = numismatico_redux('mt_listings_layout_sidebar');
}

$search_scope = 'posts';
if (numismatico_redux('mt_search_scope') == 'icos') {
	$search_scope = 'icos';
}else{
	$search_scope = 'posts';
}

// theme_ini
$theme_init = new numismatico_init_class;

if(isset($_GET['post_type']) && $_GET['post_type']=='mt_listing') {
	$class_row = "col-md-12";
}

?>

    <!-- HEADER TITLE BREADCRUBS SECTION -->
    <?php echo wp_kses_post(numismatico_header_title_breadcrumbs()); ?>

    <!-- Page content -->
    <div class="high-padding">
        <!-- Blog content -->
        <div class="container blog-posts search-post"> 
            <div class="row">

                <?php if ( class_exists( 'ReduxFrameworkPlugin' ) && function_exists('mtlistings_framework') ) { ?>
                    <?php if ( numismatico_redux('mt_listings_layout') != '' && numismatico_redux('mt_listings_layout') == 'mt_listings_left_sidebar') { ?>
                        <?php if (is_active_sidebar($sidebar)) { ?>
                            <div class="col-md-4 sidebar-content"><?php  dynamic_sidebar( $sidebar ); ?></div>
                        <?php } ?>
                    <?php } ?>
                <?php } ?>

                <div class="<?php echo esc_attr($class_row); ?> main-content">
                <?php if ( have_posts() ) : ?>
                    <div class="row">

                        <?php /* Start the Loop */ ?>
                        <?php $i = 1; ?>
                        <?php while ( have_posts() ) : the_post(); ?>
                            <?php /* Loop - Variant 1 */ ?>
                            <?php if ( class_exists('ReduxFrameworkPlugin')) { ?>
                    			<?php if ( $search_scope == 'icos' && !isset($_GET['post_type'])) { ?>
                                	<?php get_template_part( 'content', $theme_init->numismatico_blogloop_variant() ); ?>
                                <?php }elseif( $search_scope == 'icos' && isset($_GET['post_type'])){ ?>
                                	<?php get_template_part( 'content', 'icosearch' ); ?>
                            	<?php }else{ ?>
                                    <?php get_template_part( 'content', $theme_init->numismatico_blogloop_variant() ); ?>
                            	<?php } ?>
                            <?php }else{ ?>
                                <?php get_template_part( 'content', $theme_init->numismatico_blogloop_variant() ); ?>
                            <?php } ?>

                            <?php /* AD PLace*/ ?>
                            <?php if($i == 2) {
                                if (function_exists('mtlisitings_framework')) {
                                    if (numismatico_redux('mt_adplace_search')){
                                        if(numismatico_redux('mt_adplace_search_adsense_code') != '' && numismatico_redux('mt_adplace_search') == 'on_adsense'){
                                          echo numismatico_redux('mt_adplace_search_adsense_code');
                                        }elseif(numismatico_redux('mt_adplace_search_img','url') != '' && numismatico_redux('mt_adplace_search') == 'on'){  
                                            echo '<div class="adplace-search">
                                                    <a href="'. esc_url(numismatico_redux('mt_adplace_search_link')) .'" target="_blank">
                                                        <img src="'. esc_url(numismatico_redux('mt_adplace_search_img','url')) .'" alt="'.esc_attr__('adPlace', 'numismatico').'" />
                                                    </a>
                                            </div>';
                                      }
                                    }
                                }
                            } ?>
                            <?php $i++; ?>

                        <?php endwhile; ?>

                        <?php if ( class_exists('ReduxFrameworkPlugin')) { ?>
	                        <?php if ( $search_scope == 'icos' && isset($_GET['post_type'])) { ?>
	                            </div>
	                        <?php } ?>
                        <?php } ?>

                        <div class="modeltheme-pagination-holder col-md-12">             
                            <div class="modeltheme-pagination pagination">             
                                <?php the_posts_pagination(); ?>
                            </div>
                        </div>
                    </div>
                <?php else : ?>
                    <?php get_template_part( 'content', 'none' ); ?>
                <?php endif; ?>
                </div>

                <?php if ( class_exists( 'ReduxFrameworkPlugin' ) && function_exists('mtlistings_framework') ) { ?>
                    <?php if ( numismatico_redux('mt_listings_layout') != '' && numismatico_redux('mt_listings_layout') == 'mt_listings_right_sidebar') { ?>
                        <?php if(!isset($_GET['post_type'])) { ?>
	                        <?php if (is_active_sidebar($sidebar)) { ?>
	                            <div class="col-md-4 sidebar-content">
	                                <?php dynamic_sidebar( $sidebar ); ?>
	                            </div>
	                        <?php } ?>
                        <?php } ?>
                    <?php } ?>
                <?php }else{ ?>
                    <?php if(!isset($_GET['post_type'])) { ?>
	                    <div class="col-md-4 sidebar-content">
	                        <?php get_sidebar(); ?>
	                    </div>
	                <?php } ?>
                <?php } ?>
            </div>
        </div>
    </div>
<?php get_footer(); ?>