<?php
/**||-> Function: mtlisitings_currencies_list()*/

function mtlisitings_currencies_list(){ // Currencies List
	$currencies_list = array(
		'AED' => 'United Arab Emirates Dirham (Ø¯.Ø¥)',
		'AUD' => 'Australian Dollars ($)',
		'BDT' => 'Bangladeshi Taka (à§³&nbsp;)',
		'BRL' => 'Brazilian Real (R$)',
		'BGN' => 'Bulgarian Lev (Ð»Ð².)',
		'CAD' => 'Canadian Dollars ($)',
		'CLP' => 'Chilean Peso ($)',
		'CNY' => 'Chinese Yuan (Â¥)',
		'COP' => 'Colombian Peso ($)',
		'CZK' => 'Czech Koruna (KÄ)',
		'DKK' => 'Danish Krone (kr.)',
		'DOP' => 'Dominican Peso (RD$)',
		'EUR' => 'Euros (â‚¬)',
		'HKD' => 'Hong Kong Dollar ($)',
		'HRK' => 'Croatia kuna (Kn)',
		'HUF' => 'Hungarian Forint (Ft)',
		'ISK' => 'Icelandic krona (Kr.)',
		'IDR' => 'Indonesia Rupiah (Rp)',
		'INR' => 'Indian Rupee (â‚¹)',
		'NPR' => 'Nepali Rupee (à¤°à¥‚)',
		'ILS' => 'Israeli Shekel (â‚ª)',
		'JPY' => 'Japanese Yen (Â¥)',
		'KIP' => 'Lao Kip (â‚­)',
		'KRW' => 'South Korean Won (â‚©)',
		'MYR' => 'Malaysian Ringgits (RM)',
		'MXN' => 'Mexican Peso ($)',
		'NGN' => 'Nigerian Naira (â‚¦)',
		'NOK' => 'Norwegian Krone (kr)',
		'NZD' => 'New Zealand Dollar ($)',
		'PYG' => 'Paraguayan GuaranÃ­ (â‚²)',
		'PHP' => 'Philippine Pesos (â‚±)',
		'PLN' => 'Polish Zloty (zÅ‚)',
		'GBP' => 'Pounds Sterling (Â£)',
		'RON' => 'Romanian Leu (lei)',
		'RUB' => 'Russian Ruble (Ñ€ÑƒÐ±.)',
		'SGD' => 'Singapore Dollar ($)',
		'ZAR' => 'South African rand (R)',
		'SEK' => 'Swedish Krona (kr)',
		'CHF' => 'Swiss Franc (CHF)',
		'TWD' => 'Taiwan New Dollars (NT$)',
		'THB' => 'Thai Baht (à¸¿)',
		'TRY' => 'Turkish Lira (â‚º)',
		'USD' => 'US Dollars ($)',
		'VND' => 'Vietnamese Dong (â‚«)',
		'EGP' => 'Egyptian Pound (EGP)'
	);
	return $currencies_list;
	} /**||-> Function: mtlisitings_extend_redux_tabs()*/

function mtlisitings_extend_redux_tabs($sections)
	{
	$sections[] = array(
		'title' => esc_html__('MT Listings Settings', 'mtlisitings') ,
		'id' => 'mt_listings',
		'icon' => 'el el-icon-comment'
	);
	$sections[] = array(
		'title' => esc_html__('Currency', 'mtlisitings') ,
		'id' => 'mt_listings_settings_currency',
		'subsection' => true,
		'fields' => array(
            array(
                'id'       => 'mt_listings_submit_ico_status',
                'type'     => 'switch', 
                'title'    => esc_html__('Submit ICO Button', 'mtlistings'),
                'subtitle' => esc_html__('Enable or disable "Submit ICO Button".', 'mtlistings'),
                'default'  => false,
                'on'       => esc_html__( 'Enabled', 'mtlistings' ),
                'off'      => esc_html__( 'Disabled', 'mtlistings' )
            ),
			array(
				'id' => 'mt_listings_submit_ico_page',
				'type' => 'text',
				'title' => esc_html__('Header Submit ICO Button Page', 'mtlistings') ,
				'subtitle' => esc_html__('Select Page for the Header Submit ICO Button.', 'mtlistings'),
                'required' => array( 'mt_listings_submit_ico_status', '=', true ),
                'default'  => '#',
			),
			array(
				'id' => 'mt_listings_settings_currency_select',
				'type' => 'select',
				'multi' => false,
				'title' => esc_html__('Currency', 'mtlisitings') ,
				'subtitle' => __('Select Currency - Used on Archive and Single ICO Page (<strong>Fundraising Goal</strong> & <strong>Sold on Pre-Sale</strong> fields)', 'mtlisitings') ,
				'options' => mtlisitings_currencies_list() ,
				'default' => array(
					'USD'
				),
			),

			array(
				'id' => 'mt_listings_settings_currency_position',
				'type' => 'select',
				'multi' => false,
				'title' => esc_html__('Currency Sign Position', 'mtlisitings') ,
				'subtitle' => esc_html__('Select currency Sign Position', 'mtlisitings') ,
				'options' => array(
					'left' => esc_html__('Left', 'mtlisitings') ,
					'right' => esc_html__('Right', 'mtlisitings') ,
					'left_with_space' => esc_html__('Left with space', 'mtlisitings') ,
					'right_with_space' => esc_html__('Right with space', 'mtlisitings')
				),
				'default' => array(
					'left'
				),
			),
			array(
                'id'   => 'mt_divider_preloader_styling',
                'type' => 'info',
                'class' => 'mt_divider',
                'desc' => wp_kses_post( '<h3>My Account Page</h3>' )
            ),
            array(
                'id' => 'mt_listings_account_link1_title',
                'type' => 'text',
                'title' => esc_html__('My Account Link 1 Title', 'mtlistings') ,
                'subtitle' => esc_html__('Select tab name for My account Link 1', 'mtlistings'),
                'default'  => 'Submit FREE ICO',
            ),
            array(
                'id' => 'mt_listings_account_link1',
                'type' => 'text',
                'title' => esc_html__('My Account Link 1 URL', 'mtlistings') ,
                'subtitle' => esc_html__('Type your URL for My account page Link 1', 'mtlistings'),
                'desc' => esc_html__('For example: "https://numismatico.modeltheme.com/ico/submit-ico/"', 'mtlistings'),
                'default'  => 'https://numismatico.modeltheme.com/ico/submit-ico/',
            ),
            array(
                'id' => 'mt_listings_account_link2_title',
                'type' => 'text',
                'title' => esc_html__('My Account Link 2 Title', 'mtlistings') ,
                'subtitle' => esc_html__('Select tab name for My account Link 2', 'mtlistings'),
                'default'  => 'Submit Sponsored ICO',
            ),
            array(
                'id' => 'mt_listings_account_link2',
                'type' => 'text',
                'title' => esc_html__('My Account Link 2 URL', 'mtlistings') ,
                'subtitle' => esc_html__('Type your URL for My account page Link 2', 'mtlistings'),
                'desc' => esc_html__('For example: "https://numismatico.modeltheme.com/pricing-table/"', 'mtlistings'),
                'default'  => 'https://numismatico.modeltheme.com/pricing-table/',
            ),

		),
	);

	// Archive Listing Pages
	$sections[] = array(
		'title' => esc_html__('Archive Listing Pages', 'mtlisitings') ,
		'id' => 'mt_listings_settings_archive',
		'subsection' => true,
		'fields' => array(
			array(
		        'id'       => 'mt_listings_layout',
		        'type'     => 'image_select',
		        'compiler' => true,
		        'title'    => esc_html__( 'Listings Archive Layout', 'mtlistings' ),
		        'subtitle' => esc_html__( 'Select Listings Archive layout.', 'mtlistings' ),
		        'options'  => array(
		            'mt_listings_left_sidebar' => array(
		                'alt' => esc_html__('2 Columns - Left sidebar', 'mtlistings' ),
		                'img' => get_template_directory_uri().'/redux-framework/assets/sidebar-left.jpg'
		            ),
		            'mt_listings_fullwidth' => array(
		                'alt' => esc_html__('1 Column - Full width', 'mtlistings' ),
		                'img' => get_template_directory_uri().'/redux-framework/assets/sidebar-no.jpg'
		            ),
		            'mt_listings_right_sidebar' => array(
		                'alt' => esc_html__('2 Columns - Right sidebar', 'mtlistings' ),
		                'img' => get_template_directory_uri().'/redux-framework/assets/sidebar-right.jpg'
		            )
		        ),
		        'default'  => 'mt_listings_right_sidebar'
		    ),
			array(
		        'id'       => 'mt_listings_layout_sidebar',
		        'type'     => 'select',
		        'data'     => 'sidebars',
		        'title'    => esc_html__( 'Listings Archive Sidebar', 'mtlistings' ),
		        'subtitle' => esc_html__( 'Select Listings Archive Sidebar.', 'mtlistings' ),
		        'default'   => 'sidebar-1',
		        'required' => array('mt_listings_layout', '!=', 'mt_listings_fullwidth'),
		    ),
		),
	);

	// Sponsored Listing Package
	$sections[] = array(
		'title' => esc_html__('Sponsored Listing Package', 'mtlisitings') ,
		'id' => 'mt_listings_settings_package',
		'subsection' => true,
		'fields' => array(
            array(
                'id' => 'mt_premium_package_productid',
                'type' => 'text',
                'title' => esc_html__('Set WooCommerce Product ID for the Sponsored package feature', 'mtlistings'),
                'subtitle' => esc_html__('Learn how to get the Product ID: https://bit.ly/2RW8b0n', 'mtlistings'),
                'default' => ''
            ),
		),
	);


	// Single Listing Page
	$sections[] = array(
		'title' => esc_html__('Single Listing Page', 'mtlisitings') ,
		'id' => 'mt_listings_settings_single',
		'subsection' => true,
		'fields' => array(
			array(
				'id' => 'mt_related_listings',
				'type' => 'switch',
				'title' => esc_html__('Related Listings', 'mtlisitings') ,
				'subtitle' => esc_html__('Enable or disable related Listings', 'mtlisitings') ,
				'default' => true,
			) ,
		) ,
	);
	$sections[] = array(
		'title' => esc_html__('MT AdPlaces', 'mtlisitings') ,
		'id' => 'mt_adplaces',
		'icon' => 'el el-cogs'
	);
	$sections[] = array(
		'title' => esc_html__('AdPlace Single ICO Listing', 'mtlisitings') ,
		'id' => 'mt_adplaces_1',
		'subsection' => true,
		'fields' => array(
            array(
                'id'       => 'mt_adplace_single',
                'type'     => 'button_set',
                'title'    => esc_html__( 'AdPlace - ICO Listing - Top/Bottom', 'numismatico' ),
                'subtitle' => esc_html__( 'Select your "AdPlace ICO Listing - Top/Bottom"', 'numismatico' ),
                //Must provide key => value pairs for radio options
                'options'  => array(
                    'on_adsense' => 'Enable AdSense',
                    'on'         => 'Enable Banner Ad',
                    'off' 		 => 'Disable Ad'
                ),
                'default'  => 'off'
            ),
            array(
                'id' => 'mt_adplace_single_top_link',
                'type' => 'text',
                'title' => esc_html__('AdPlace Top URL', 'mtlistings'),
                'subtitle' => esc_html__('Type your AdPlace ICO Listing - Top URL.', 'mtlistings'),
                'required' => array( 'mt_adplace_single', '=', 'on' ),
                'desc' => esc_html__('For example: "https://modeltheme.com"', 'mtlistings'),
                'default' => 'https://'
            ),
			array(
				'id' => 'mt_adplace_single_top_img',
				'type' => 'media',
				'url' => true,
				'title' => esc_html__('Choose image for AdPlace Top', 'mtlisitings'),
				'subtitle' => esc_html__('Use the upload button to import media.', 'mtlisitings'),
				'compiler' => 'true',
				'required' => array( 'mt_adplace_single', '=', 'on' )
			),
            array(
                'id' => 'mt_adplace_single_bottom_link',
                'type' => 'text',
                'title' => esc_html__('AdPlace Bottom URL', 'mtlistings'),
                'subtitle' => esc_html__('Type your AdPlace ICO Listing - Bottom URL.', 'mtlistings'),
                'required' => array( 'mt_adplace_single', '=', 'on' ),
                'desc' => esc_html__('For example: "https://modeltheme.com"', 'mtlistings'),
                'default' => 'https://'
            ),
			array(
				'id' => 'mt_adplace_single_bottom_img',
				'type' => 'media',
				'url' => true,
				'title' => esc_html__('Choose image for AdPlace Bottom', 'mtlisitings'),
				'subtitle' => esc_html__('Use the upload botton to import media.', 'mtlisitings'),
				'compiler' => 'true',
				'required' => array( 'mt_adplace_single', '=', 'on' )
			),
            array(
                'id' => 'mt_adplace_single_adsense_code',
                'type' => 'textarea',
                'title' => esc_html__('AdSense code', 'mtlistings'),
                'subtitle' => esc_html__('Paste your AdSense Code into the textarea.', 'mtlistings'),
                'desc' => esc_html__('The height of this ad will be automatically set from your AdSense account', 'mtlistings'),
                'required' => array( 'mt_adplace_single', '=', 'on_adsense' ),
                'default' => ''
            ),
		),
	);

	$sections[] = array(
		'title' => esc_html__('AdPlace Blog Post', 'mtlisitings') ,
		'id' => 'mt_adplaces_blog_post',
		'subsection' => true,
		'fields' => array(
            array(
                'id'       => 'mt_adplace_blog_post',
                'type'     => 'button_set',
                'title'    => esc_html__( 'AdPlace - Blog Post', 'numismatico' ),
                'subtitle' => esc_html__( 'Select your "AdPlace content blog post"', 'numismatico' ),
                //Must provide key => value pairs for radio options
                'options'  => array(
                    'on_adsense' => 'Enable AdSense',
                    'on'         => 'Enable Banner Ad',
                    'off' 		 => 'Disable Ad'
                ),
                'default'  => 'off'
            ),
            array(
                'id' => 'mt_adplace_blog_post_link',
                'type' => 'text',
                'title' => esc_html__('AdPlace URL', 'mtlistings'),
                'subtitle' => esc_html__('Type your AdPlace blog post URL.', 'mtlistings'),
                'required' => array( 'mt_adplace_blog_post', '=', 'on' ),
                'desc' => esc_html__('For example: "https://modeltheme.com"', 'mtlistings'),
                'default' => 'https://'
            ),
			array(
				'id' => 'mt_adplace_blog_post_img',
				'type' => 'media',
				'url' => true,
				'title' => esc_html__('Choose image for AdPlace Blog Post', 'mtlisitings'),
				'subtitle' => esc_html__('Use the upload button to import media.', 'mtlisitings'),
				'compiler' => 'true',
				'required' => array( 'mt_adplace_blog_post', '=', 'on' )
			),
            array(
                'id' => 'mt_adplace_blog_post_adsense_code',
                'type' => 'textarea',
                'title' => esc_html__('AdSense code', 'mtlistings'),
                'subtitle' => esc_html__('Paste your AdSense Code into the textarea.', 'mtlistings'),
                'desc' => esc_html__('The height of this ad will be automatically set from your AdSense account', 'mtlistings'),
                'required' => array( 'mt_adplace_blog_post', '=', 'on_adsense' ),
                'default' => ''
            ),
		),
	);

	$sections[] = array(
		'title' => esc_html__('AdPlace Search', 'mtlisitings') ,
		'id' => 'mt_adplaces_search',
		'subsection' => true,
		'fields' => array(
            array(
                'id'       => 'mt_adplace_search',
                'type'     => 'button_set',
                'title'    => esc_html__( 'AdPlace - Search', 'numismatico' ),
                'subtitle' => esc_html__( 'Select your "AdPlace Search"', 'numismatico' ),
                //Must provide key => value pairs for radio options
                'options'  => array(
                    'on_adsense' => 'Enable AdSense',
                    'on'         => 'Enable Banner Ad',
                    'off' 		 => 'Disable Ad'
                ),
                'default'  => 'off'
            ),
            array(
                'id' => 'mt_adplace_search_link',
                'type' => 'text',
                'title' => esc_html__('AdPlace URL', 'mtlistings'),
                'subtitle' => esc_html__('Type your AdPlace Search URL.', 'mtlistings'),
                'required' => array( 'mt_adplace_search', '=', 'on' ),
                'desc' => esc_html__('For example: "https://modeltheme.com"', 'mtlistings'),
                'default' => 'https://'
            ),
			array(
				'id' => 'mt_adplace_search_img',
				'type' => 'media',
				'url' => true,
				'title' => esc_html__('Choose image for AdPlace Search', 'mtlisitings'),
				'subtitle' => esc_html__('Use the upload button to import media.', 'mtlisitings'),
				'compiler' => 'true',
				'required' => array( 'mt_adplace_search', '=', 'on' )
			),
            array(
                'id' => 'mt_adplace_search_adsense_code',
                'type' => 'textarea',
                'title' => esc_html__('AdSense code', 'mtlistings'),
                'subtitle' => esc_html__('Paste your AdSense Code into the textarea.', 'mtlistings'),
                'desc' => esc_html__('The height of this ad will be automatically set from your AdSense account', 'mtlistings'),
                'required' => array( 'mt_adplace_search', '=', 'on_adsense' ),
                'default' => ''
            ),
		),
	);

	$sections[] = array(
		'title' => esc_html__('AdPlace Category', 'mtlisitings') ,
		'id' => 'mt_adplaces_category',
		'subsection' => true,
		'fields' => array(
            array(
                'id'       => 'mt_adplace_category',
                'type'     => 'button_set',
                'title'    => esc_html__( 'AdPlace - Category', 'numismatico' ),
                'subtitle' => esc_html__( 'Select your "AdPlace Category"', 'numismatico' ),
                //Must provide key => value pairs for radio options
                'options'  => array(
                    'on_adsense' => 'Enable AdSense',
                    'on'         => 'Enable Banner Ad',
                    'off' 		 => 'Disable Ad'
                ),
                'default'  => 'off'
            ),
            array(
                'id' => 'mt_adplace_category_link',
                'type' => 'text',
                'title' => esc_html__('AdPlace URL', 'mtlistings'),
                'subtitle' => esc_html__('Type your AdPlace Category URL.', 'mtlistings'),
                'required' => array( 'mt_adplace_category', '=', 'on' ),
                'desc' => esc_html__('For example: "https://modeltheme.com"', 'mtlistings'),
                'default' => 'https://'
            ),
			array(
				'id' => 'mt_adplace_category_img',
				'type' => 'media',
				'url' => true,
				'title' => esc_html__('Choose image for AdPlace Search', 'mtlisitings'),
				'subtitle' => esc_html__('Use the upload button to import media.', 'mtlisitings'),
				'compiler' => 'true',
				'required' => array( 'mt_adplace_category', '=', 'on' )
			),
            array(
                'id' => 'mt_adsense_category_code',
                'type' => 'textarea',
                'title' => esc_html__('AdSense code', 'mtlistings'),
                'subtitle' => esc_html__('Paste your AdSense Code into the textarea.', 'mtlistings'),
                'desc' => esc_html__('The height of this ad will be automatically set from your AdSense account', 'mtlistings'),
                'required' => array( 'mt_adplace_category', '=', 'on_adsense' ),
                'default' => ''
            ),
		),
	);

	$sections[] = array(
		'title' => esc_html__('AdPlace ICO List', 'mtlisitings') ,
		'id' => 'mt_adplaces_ico_list',
		'subsection' => true,
		'fields' => array(
            array(
                'id'       => 'mt_adplace_ico_list',
                'type'     => 'button_set',
                'title'    => esc_html__( 'AdPlace - ICO List', 'numismatico' ),
                'subtitle' => esc_html__( 'Select your "AdPlace ICO List"', 'numismatico' ),
                //Must provide key => value pairs for radio options
                'options'  => array(
                    'on_adsense' => 'Enable AdSense',
                    'on'         => 'Enable Banner Ad',
                    'off' 		 => 'Disable Ad'
                ),
                'default'  => 'off'
            ),
            array(
                'id' => 'mt_adplace_ico_list_link',
                'type' => 'text',
                'title' => esc_html__('AdPlace URL', 'mtlistings'),
                'subtitle' => esc_html__('Type your AdPlace ICO List URL.', 'mtlistings'),
                'required' => array( 'mt_adplace_ico_list', '=', 'on' ),
                'desc' => esc_html__('For example: "https://modeltheme.com"', 'mtlistings'),
                'default' => 'https://'
            ),
			array(
				'id' => 'mt_adplace_ico_list_img_1_1',
				'type' => 'media',
				'url' => true,
				'title' => esc_html__('Choose image for AdPlace ICO List 1 ICO / Row', 'mtlisitings'),
				'subtitle' => esc_html__('Upload Image (1/1) - When the grid shows 1 ICO / Row', 'mtlisitings'),
				'compiler' => 'true',
				'required' => array( 'mt_adplace_ico_list', '=', 'on' )
			),
			array(
				'id' => 'mt_adplace_ico_list_img_1_2',
				'type' => 'media',
				'url' => true,
				'title' => esc_html__('Choose image for AdPlace ICO List 2 ICOs / Row', 'mtlisitings'),
				'subtitle' => esc_html__('Upload Image (1/2) - When the grid shows 2 ICOs / Row', 'mtlisitings'),
				'compiler' => 'true',
				'required' => array( 'mt_adplace_ico_list', '=', 'on' )
			),
			array(
				'id' => 'mt_adplace_ico_list_img_1_3',
				'type' => 'media',
				'url' => true,
				'title' => esc_html__('Choose image for AdPlace ICO List 3 ICOs / Row', 'mtlisitings'),
				'subtitle' => esc_html__('Upload Image (1/3) - When the grid shows 3 ICOs / Row', 'mtlisitings'),
				'compiler' => 'true',
				'required' => array( 'mt_adplace_ico_list', '=', 'on' )
			),
			array(
				'id' => 'mt_adplace_ico_list_img_1_4',
				'type' => 'media',
				'url' => true,
				'title' => esc_html__('Choose image for AdPlace ICO List ', 'mtlisitings'),
				'subtitle' => esc_html__('Upload Image (1/4) - When the grid shows 4 ICOs / Row', 'mtlisitings'),
				'compiler' => 'true',
				'required' => array( 'mt_adplace_ico_list', '=', 'on' )
			),
            array(
                'id' => 'mt_adplace_ico_list_adsense_code',
                'type' => 'textarea',
                'title' => esc_html__('AdSense code', 'mtlistings'),
                'subtitle' => esc_html__('Paste your AdSense Code into the textarea.', 'mtlistings'),
                'desc' => esc_html__('The height of this ad will be automatically set from your AdSense account', 'mtlistings'),
                'required' => array( 'mt_adplace_ico_list', '=', 'on_adsense' ),
                'default' => ''
            ),
		),
	);


	return $sections;
	}

// In this example OPT_NAME is the returned opt_name.
add_filter("redux/options/redux_demo/sections", 'mtlisitings_extend_redux_tabs');

?>