<?php 
/**
||-> Shortcode: BlogPos01
*/
function modeltheme_shortcode_ico_video_resources($params, $content) {
    extract( shortcode_atts( 
        array(
            'animation'           =>'',
            'category'            => '',
            'number'              =>'',
        ), $params ) );



    $html = '';
    $html .= '<div class="mt_ico_video_resources wow '.$animation.'">';
    $html .= '<div class="row">';
    
    $args_mtlistings = array(
            'posts_per_page'   => $number,
            'orderby'          => 'post_date',
            'order'            => 'DESC',
            'post_type'        => 'mt_listing',
            'post_status'      => 'publish' 
            ); 
    $mtlistings = get_posts($args_mtlistings);

    foreach ($mtlistings as $mtlisting) {

        #thumbnail
        $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( $mtlisting->ID ),'numismatico_news_shortcode_1000x500' );
        
        if ($thumbnail_src) {
            $post_img = '<img class="blog_post_image" src="'. esc_url($thumbnail_src[0]) . '" alt="'.$mtlisting->post_title.'" />';
        }else{
            $post_img = '';
        }


    		// TAXONOMY PHOTO/
        $term_list_categories = wp_get_post_terms($mtlisting->ID, 'mt-listing-category2');
    		$taxonomy_image_id = get_term_meta ( $term_list_categories[0]->term_id, 'category-image-id', true );
    		$tax_img = '';
    		if (wp_get_attachment_image ( $taxonomy_image_id, 'thumbnail' )) {
    			$tax_img = wp_get_attachment_image ( $taxonomy_image_id, 'thumbnail' );
    		}

          $term_list = wp_get_post_terms($mtlisting->ID, 'mt-listing-category2');

          $mt_listing_ticker = get_post_meta( $mtlisting->ID, 'mt_listing_ticker', true );
          $mt_select_font = get_post_meta( $mtlisting->ID, 'mt_select_font', true );
          $mt_font_cryptocoins_icons = get_post_meta( $mtlisting->ID, 'mt_font_cryptocoins_icons', true );
          $mt_font_awesome_icons = get_post_meta( $mtlisting->ID, 'mt_font_awesome_icons', true );
          $mt_font_simple_line = get_post_meta( $mtlisting->ID, 'mt_font_simple_line_icons', true );
          $metabox_video = get_post_meta( $mtlisting->ID, 'mt_video_tour', true );
          parse_str( parse_url( $metabox_video, PHP_URL_QUERY ), $newid );
          $term_list_categories = wp_get_post_terms($mtlisting->ID, 'mt-listing-category2');

          $mt_select_rating_star_recent = get_post_meta( $mtlisting->ID, 'mt_select_rating_star', true );
          if(!empty($mt_select_rating_star_recent)) {
            $percentage_rating_recent = $mt_select_rating_star_recent;
          } else {
            $percentage_rating_recent = '0%';
          }  

          $html.='<div class="col-md-4">
                      <article class="single-post list-view">
                        <div class="blog_custom">
                          <!-- POST THUMBNAIL -->
                          <div class="col-md-12 post-thumbnail">
                            <div class="embed-responsive embed-responsive-16by9">
                                <iframe class="embed-responsive-item" src="//www.youtube.com/embed/'.$newid['v'].'"></iframe>
                            </div>
                            <div class="mt_ico_video_resources_desc">
                            <h4 class="post-name row">
                              <a href="'.get_permalink($mtlisting->ID).'" title="'. $mtlisting->post_title .'">'. $mtlisting->post_title .'</a>
                            </h4>
                            <div class="review-recent">
                              <div class="parent-rating-star">
                                <div class="rating-star" 
                                    style="background-image:url('.plugins_url( 'images/stars.svg', dirname(__FILE__) ).')">
                                </div>
                                <div class="fill-rating-star" 
                                    style="background-image:url('.plugins_url( 'images/fill_stars.svg', dirname(__FILE__) ).'); width:'.esc_attr($percentage_rating_recent).'">
                                </div>
                              </div>
                            </div>';
                            if (!empty($term_list[0]->name)) {
                                $html.='<div class="mt_ico_video_resources_category">'. $tax_img . esc_html($term_list[0]->name).'</div>';
                            }

                      $html.='<div class="clearfix"></div>';

                      $html.='<div class="ico-icon">';
                              if (!empty($post_img)) {
                                $html .= wp_kses_post($post_img);
                              } else {
                                $html .= '<div class="featured-icon">';
                                  
                                  if (isset($mt_select_font) && $mt_select_font == 'cryptocoins_icons') {
                                    if($mt_font_cryptocoins_icons) {
                                      $html .= '<i class="'.esc_attr($mt_font_cryptocoins_icons).'"></i>';
                                    }
                                  } elseif (isset($mt_select_font) && $mt_select_font == 'font_awesome_icons') {
                                    if($mt_font_awesome_icons) {
                                      $html .= '<i class="'.esc_attr($mt_font_awesome_icons).'"></i>';
                                    }
                                  } elseif (isset($mt_select_font) && $mt_select_font == 'simple_line_icons') {
                                    if($mt_font_simple_line) {
                                      $html .= '<i class="'.esc_attr($mt_font_simple_line).'"></i>';
                                    }
                                  }
                                $html.='</div>';
                              }
                        $html.='</div>';

                      $html.='</div>';
                     $html.='</div>';
                     

                $html.='</div>
                      </article>
                    </div>';

      }

    $html .= '</div>';
    $html .= '</div>';
    return $html;
}
add_shortcode('mt_ico_video_resources', 'modeltheme_shortcode_ico_video_resources');
/**
||-> Map Shortcode in Visual Composer with: vc_map();
*/
if ( is_plugin_active( 'js_composer/js_composer.php' ) ) {
  require_once __DIR__ . '/../vc-shortcodes.inc.arrays.php';

  vc_map( array(
     "name" => esc_attr__("MT - ICO Video Resources", 'mtlisitings'),
     "base" => "mt_ico_video_resources",
     "category" => esc_attr__('MT: ModelTheme', 'mtlisitings'),
     "icon" => "smartowl_shortcode",
     "params" => array(
        array(
          "group" => "Options",
          "type" => "textfield",
          "holder" => "div",
          "class" => "",
          "heading" => esc_attr__( "Number of posts", 'mtlisitings' ),
          "param_name" => "number",
          "value" => "",
          "description" => esc_attr__( "Enter number of blog post to show.", 'mtlisitings' )
        ),
        array(
           "type" => "dropdown",
           "group" => "Options",
           "holder" => "div",
           "class" => "",
           "heading" => esc_attr__("Select Category", 'mtlisitings'),
           "param_name" => "category",
           "description" => esc_attr__("Please select category", 'mtlisitings'),
           "std" => 'Default value',
           "value" => $taxonomy
        ),
        array(
          "group" => "Animation",
          "type" => "dropdown",
          "heading" => esc_attr__("Animation", 'mtlisitings'),
          "param_name" => "animation",
          "std" => 'fadeInLeft',
          "holder" => "div",
          "class" => "",
          "description" => "",
          "value" => $animations_list
        )
      )
  ));
}
?>