<?php 


/**

||-> Shortcode: Car Search

*/
function modeltheme_shortcode_ico_search($params, $content) {
    extract( shortcode_atts( 
        array(
            'width_type'          				=>'',
            'mt_ico_search_text_color'          =>'',
            'btn_background_color_normal'       =>'',
            'btn_background_color_hover'        =>'',
            'btn_text_color'          			=>'',
            'popular_searches'              	=>'',
            'animation'           				=>'',
            'mtsearchform_style_variant'        =>'',
            'extra_class'              			=>'',
            'mt_ico_search_delimiter_color'		=>''
        ), $params ) );

    
    $html = '';

    $ico_replacement = __('ICO', 'mtlisitings');
    if (function_exists('icoswitch_is_cpt_title_singular')) {
      if (icoswitch_is_cpt_title_singular()) {
        $ico_replacement = icoswitch_is_cpt_title_singular();
      }
    }

    if (isset($btn_background_color_hover)) {
      $html .= '<style>
                  .slider-state-submit input:hover{
                    background: '.$btn_background_color_hover.' !important;
                  }
                  .mt-car-search .select2-container--default .select2-selection--single .select2-selection__rendered {
                      color: '.$mt_ico_search_text_color.' !important;
                  }
                  .mt-car-search .slider-state-search .search-field.form-control::-webkit-input-placeholder{
                      color: '.$mt_ico_search_text_color.' !important;
                  }
                  .mt-car-search .slider-state-search .search-field.form-control::-moz-placeholder{
                      color: '.$mt_ico_search_text_color.' !important;
                  }
                  .mt-car-search .slider-state-search .search-field.form-control:-ms-input-placeholder{
                      color: '.$mt_ico_search_text_color.' !important;
                  }
                  .mt-car-search .slider-state-search .search-field.form-control:-moz-placeholder{
                      color: '.$mt_ico_search_text_color.' !important;
                  }
                  .mt-car-search .select2.select2-container .select2-selection .select2-selection__arrow::before{
                      color: '.$mt_ico_search_text_color.' !important;
                  }
                  span.select2-selection__arrow:after {
                      background:  '.$mt_ico_search_delimiter_color.' !important;
                  }
                  .mtsearchform-style-v2.mt-car-search .slider-state-submit input {
                      border-color: '.$btn_background_color_normal.' !important;
                  }
                  .mtsearchform-style-v2.mt-car-search .slider-state-submit input:hover {
                      border-color: '.$btn_background_color_hover.' !important;
                  }
                </style>';
    }

    if (isset($btn_text_color)) {
      $html .= '<style>
                  .mtsearchform-style-v2.mt-car-search .submit .form-control:hover:hover{
                      color: '.$btn_text_color.' !important;
                  }
                </style>';
    }



    $html .= '<div class="mt-car-search wow '.esc_attr($animation).' '.$mtsearchform_style_variant.' '.$extra_class.'">
                <form method="GET" action="'.home_url( '/' ).'">
                  <input type="hidden" name="post_type" value="mt_listing" />
                  <div class="row">

                    <div class="slider-state-select col-md-3 '.esc_attr($width_type).'">
                      <select name="mt-listing-category" class="select-car-category form-control">';
                        $html .= "<option value=''>".esc_html__('Choose '.$ico_replacement.' Scope', 'mtlisitings')."</option>";
                        $terms_l = get_terms( 'mt-listing-category' );
                        foreach ($terms_l as $term) {
                          if ($term->parent == 0) {
                            $html .= "<option value='{$term->slug}'>{$term->name}</option>";
                          }
                        }
                      $html .= '</select>
                    </div>  

                    <div class="slider-state-select col-md-3 '.esc_attr($width_type).'">          
                      <select name="mt-listing-category2" class="select-car-type form-control">';
                        $terms_c = get_terms( 'mt-listing-category2' );
                        $html .= "<option value=''>".esc_html__('Choose '.$ico_replacement.' Type', 'mtlisitings')."</option>";
                        foreach ($terms_c as $term) {
                          $html .= "<option value='{$term->slug}'>{$term->name}</option>";
                        }
                      $html .= '</select>
                    </div>

                    <div class="slider-state-search col-md-3 '.esc_attr($width_type).'">
                      <input type="search" class="search-field form-control" placeholder="'.esc_attr__( 'Type keyword…', 'mtlisitings' ).'" value="'.get_search_query().'" name="s" />
                    </div>  

                    <div class="slider-state-submit col-md-3 '.esc_attr($width_type).' submit">
                      <input style="background: '.$btn_background_color_normal.'" type="submit" value="'.esc_attr__('FIND NOW', 'mtlisitings').'" class="form-control btn btn-warning">
                    </div>

                  </div>
                </form>';

                  if ($popular_searches == 'on') {
                    $html .= '<div class="text-center mt-listings-popular-searches-parent">';
            			    if ($terms_c) {
            				  	$html .= esc_html__('Popular Searches:', 'mtlisitings');
            				  	$html .= '<ul class="mt-listings-popular-searches">';
            				    foreach ($terms_c as $term) {
            				        $html .= '<li><a href="'.get_term_link( $term ).'">'.$term->name.'</a></li>';
            				    }
            				  	$html .= '</ul>';
            			    }
                	  $html .= '</div>';
                  }


    $html .= '</div>';
    return $html;
}
add_shortcode('mt_ico_search', 'modeltheme_shortcode_ico_search');

/**

||-> Map Shortcode in Visual Composer with: vc_map();

*/
if ( is_plugin_active( 'js_composer/js_composer.php' ) ) {

    require_once __DIR__ . '/../vc-shortcodes.inc.arrays.php';

    vc_map( array(
     "name" => esc_attr__("MT - Ico Search", 'mtlisitings'),
     "base" => "mt_ico_search",
     "category" => esc_attr__('MT: ModelTheme', 'mtlisitings'),
     "icon" => "smartowl_shortcode",
     "params" => array(
        array(
           "group" => "Options",
           "type" => "dropdown",
           "holder" => "div",
           "class" => "",
           "heading" => esc_attr__("With type"),
           "param_name" => "width_type",
           "std" => '',
           "description" => esc_attr__("Please choose the with type"),
           "value" => array(
            esc_attr__('Boxed', 'mtlisitings')          => '',
            esc_attr__('Full width', 'mtlisitings')     => 'full_with_row',
           )
        ),
        array(
            "group" => "Options",
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => esc_attr__("Style Variant", 'mtlisitings'),
            "param_name" => "mtsearchform_style_variant",
            "std" => '',
            "description" => "",
            "value" => array(
                esc_attr__('Style 1', 'mtlisitings')         => '',
                esc_attr__('Style 2', 'mtlisitings')         => 'mtsearchform-style-v2',
            )
        ),
        array(
            "group" => "Options",
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => esc_attr__("Popular Searches", 'mtlisitings'),
            "param_name" => "popular_searches",
            "std" => '',
            "description" => "",
            "value" => array(
                esc_attr__('On / Show', 'mtlisitings')         => 'on',
                esc_attr__('Off / Hide', 'mtlisitings')         => 'off',
            )
        ),
        array(
            "group" => "Options",
            "type" => "textfield",
            "heading" => __("Extra class name", "modeltheme"),
            "param_name" => "extra_class",
            "description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "modeltheme")
        ),
        array(
          "group" => "Styling",
          "type" => "colorpicker",
          "class" => "",
          "heading" => esc_attr__( "Text Fields Color", 'mtlisitings' ),
          "param_name" => "mt_ico_search_text_color",
          "value" => "", //Default color
          "description" => esc_attr__( "Text Fields Color - Placeholder", 'mtlisitings' )
        ),
        array(
          "group" => "Styling",
          "type" => "colorpicker",
          "class" => "",
          "heading" => esc_attr__( "Form Delimiter Color", 'mtlisitings' ),
          "param_name" => "mt_ico_search_delimiter_color",
          "value" => ""
        ),
        array(
          "group" => "Styling",
          "type" => "colorpicker",
          "class" => "",
          "heading" => esc_attr__( "Button Text Color", 'mtlisitings' ),
          "param_name" => "btn_text_color",
          "value" => ""
        ),
        array(
          "group" => "Styling",
          "type" => "colorpicker",
          "class" => "",
          "heading" => esc_attr__( "'Find Now' Button Background", 'mtlisitings' ),
          "param_name" => "btn_background_color_normal",
          "value" => "", //Default color
          "description" => esc_attr__( "'Find Now' Button Background - Normal State", 'mtlisitings' )
        ),
        array(
          "group" => "Styling",
          "type" => "colorpicker",
          "class" => "",
          "heading" => esc_attr__( "'Find Now' Button Background Hover", 'mtlisitings' ),
          "param_name" => "btn_background_color_hover",
          "value" => "", //Default color
          "description" => esc_attr__( "'Find Now' Button Background - Hover State", 'mtlisitings' )
        ),
        array(
          "group" => "Animation",
          "type" => "dropdown",
          "heading" => esc_attr__("Animation", 'mtlisitings'),
          "param_name" => "animation",
          "std" => 'fadeInLeft',
          "holder" => "div",
          "class" => "",
          "description" => "",
          "value" => $animations_list
        )
      )
  ));
}