<?php
/**
* Content Single
*/

$breadcrumbs_on_off             = get_post_meta( get_the_ID(), 'breadcrumbs_on_off',               true );
?>


<!-- HEADER TITLE BREADCRUBS SECTION -->
<?php 
if ( function_exists('modeltheme_framework')) {
    if (isset($breadcrumbs_on_off) && $breadcrumbs_on_off == 'yes' || $breadcrumbs_on_off == '') {
        echo numismatico_header_title_breadcrumbs();
    }
}else{
    echo wp_kses_post(numismatico_header_title_breadcrumbs());
}
?>


<article id="post-<?php the_ID(); ?>" <?php post_class('post high-padding spacing_mobile_40 spacing_tablets_60'); ?>>
    <div class="container">
       <div class="row">
            <!-- POST CONTENT -->
            <div class="col-md-12 main-content mt-events-style-v2">
                <div class="row">
                    <!-- HEADER -->
                    <div class="col-md-5 article-header">
                        <div class="article-details">
                            <?php $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ),'numismatico_blog_900x550' ); 
                            if($thumbnail_src) { ?>
                                <?php the_post_thumbnail( 'numismatico_blog_900x550' ); ?>
                            <?php } ?>
                        </div>
                    </div>
                    <!-- CONTENT -->
                    <div class="col-md-7 article-content">

                        <h1 class="post-title">
                            <strong><?php echo esc_html(get_the_title()); ?></strong>
                        </h1>

                        <div class="post-category-comment-date row">
                            <span class="post-date">
                                <i class="icon-calendar"></i>
                                <?php echo esc_html(get_the_date()); ?>
                            </span>
                            <span class="post-categories">
                                <?php echo wp_kses_post(get_the_term_list( get_the_ID(), 'category', '<i class="icon-tag"></i>', ', ' )); ?>
                            </span>
                            <span class="post-comments">
                                <i class="icon-bubbles icons"></i>
                                <a href="<?php echo esc_url(get_the_permalink().'#comments'); ?>"><?php comments_number( '0', '1', '%' ); ?></a>
                            </span>  
                        </div>

                        <?php the_content(); ?>
                        <div class="clearfix"></div>

                        <div class="mt_event_countdown mt_listing_countdown col-md-8">
                        <?php
                            $mt_event_date = get_post_meta( get_the_ID(), 'mt_event_date', true );
                            $mt_event_date_modified = date("Y/n/j", strtotime($mt_event_date));
                            echo do_shortcode('[mt-countdown date="'.esc_attr($mt_event_date_modified).'"]');
                        ?>
                        </div>

                        <div class="clearfix"></div>
                        <?php
                            wp_link_pages( array(
                                'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'numismatico' ),
                                'after'  => '</div>',
                            ) );
                        ?>
                    </div>

                    <div class="clearfix"></div>


                       <?php 
                          global  $dynamic_featured_image;
                          $featured_images = $dynamic_featured_image->get_featured_images( get_the_ID() ); 
                        ?>
                        <?php if (!empty($featured_images)) { ?>
                        <div class="col-md-12 single-event-gallery-block">
                         <div class="ico-info">
                          <div class="panel panel-single-icondrops">
                            <div class="panel-body"><?php esc_html_e('Event Gallery','numismatico'); ?>    </div>
                          </div>
                          <div class="mt_listing--gallery text-center single-icondrops-content">
                                <?php
                                    $photos_number = '0';
                                    if( !is_null($featured_images) ){
                                        $photos_number = count($featured_images);
                                    }
                                    $final_photos_number = $photos_number + 1;
                                ?>
                                <?php
                                    if( !is_null($featured_images) ){
                                      $medias = array();
                                      foreach($featured_images as $images){
                                          $attachment_id = $images['attachment_id'];
                                          $medias[] = $attachment_id;
                                      }
                                      $ids = '';
                                      $len = count($medias);
                                      $i = 0;
                                      foreach($medias as $media){
                                        $multiple_featured_image1 = wp_get_attachment_url( $media, 'full' );
                                        echo '<div class="col-md-3">';
                                          echo '<a class="mt_listing--single-gallery" href="'.esc_url($multiple_featured_image1).'">';
                                            echo '<div class="ico-screenshot">';
                                              echo '<img src="'.esc_url($multiple_featured_image1).'">'; 
                                              echo '<div class="flex-zone">';
                                              
                                                echo '<span class="flex-zone-inside view-image-btn btn"><i class="fa fa-search" aria-hidden="true"></i></span>';
                                              
                                              echo '</div>';
                                            echo '</div>';
                                          echo '</a>';
                                        echo '</div>';
                                      }
                                    } 
                                ?>
                           </div>  
                          </div>
                          <?php } ?> 
                        </div>


                    <div class="clearfix"></div>
                    <div class="col-md-12 article-content event-article-comments">
                        <!-- COMMENTS -->
                        <?php
                            // If comments are open or we have at least one comment, load up the comment template
                            if ( comments_open() || get_comments_number() ) {
                                comments_template();
                            }
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</article>