<?php
/*
* Template Name: Numismatico Events List
*/


get_header(); 

?>



<!-- HEADER TITLE BREADCRUBS SECTION -->
<?php echo wp_kses_post(numismatico_header_title_breadcrumbs()); ?>


    <!-- Page content -->
    <?php
    wp_reset_postdata();
    $paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
    $args = array(
        // 'posts_per_page'   => -1,
        'post_type'        => 'mt_event',
        'order'            => 'ASC',
        'orderby'          => 'meta_value_num',
        'meta_query' => array(
            array(
                'key' => 'mt_event_date',
                'compare' => '<=',
                'value' => time(), // Current timestamp.

            ),
        ),
        'post_status'      => 'publish' 
    ); 
    $posts = new WP_Query( $args );

echo '<div class="high-padding">';
    echo '<div class="container">';
        echo '<div class="row">';
            echo '<div class="events-content mt-events-block container">';

                echo '<div class="mt-single-event-head">
                               <div class="mt-single-event-innerhead">
                                  <div class="col-md-1 mt-single-event-innerhead-left"><p class="no-margin">'.esc_html__('Event', 'numismatico').'</p></div>
                                  <div class="col-md-11 mt-single-event-innerhead-right">
                                     <div class="row">
                                        <div class="col-md-6 events-title-subtitle"></div>
                                        <div class="col-md-2 text-center">
                                           <p class="no-margin">'.esc_attr__('Location', 'numismatico').'</p>
                                        </div>
                                        <div class="col-md-2 text-center">
                                           <p class="no-margin">'.esc_html__('Category', 'numismatico').'</p>
                                        </div>
                                        <div class="col-md-2 event-meta text-center">
                                           <p class="no-margin">'.esc_html__('Date', 'numismatico').'</p>
                                        </div>
                                     </div>
                                  </div>
                               </div>
                            </div>';


                if ( $posts->have_posts() ) : ?>
                    <?php /* Start the Loop */ ?>
                    <div class="events-content mt-events-block">

                        <?php /* Start the Loop */ ?>
                        <?php while ( $posts->have_posts() ) : $posts->the_post(); ?>

                            <?php 
                                #Content
                                $content_post = get_post(get_the_ID());
                                $content = $content_post->post_content;
                                $content = apply_filters('the_content', $content);
                                $content = str_replace(']]>', ']]&gt;', $content);
                                $date = get_post_meta( get_the_ID(), 'mt_event_date', true );
                                $location = get_post_meta( get_the_ID(), 'mt_event_location', true );
                                $featured_status = get_post_meta( get_the_ID(), 'mt_event_featured_status', true );
                                $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ),'mt_390x275' );

                                $sponsored = '';
                                if (isset($featured_status) && $featured_status != '' && $featured_status == 'yes') {
                                    $sponsored = 'sponsored-event';
                                }

                                echo '<div class="mt-single-event '.esc_attr($sponsored).'" data-date="'.date("d/m/Y", strtotime($date)).'">';
                                    echo '<div class="mt-single-event-inner relative '.esc_attr($sponsored).'">';
                                        if (isset($featured_status) && $featured_status != '' && $featured_status == 'yes') {
                                            echo '<div class="event-box-corner"></div>';
                                        }
                                        echo '<div class="col-md-1 timeline_image_holder">';
                                            if($thumbnail_src) { 
                                                echo '<a href="'.esc_url(get_permalink(get_the_ID())).'"><img src="'. esc_url($thumbnail_src[0]) . '" alt="'. get_the_title() .'" /></a>';
                                            }
                                        echo '</div>';
                                        echo '<div class="col-md-11 timeline_text_holder">';

                                            echo '<div class="row">';
                                                echo '<div class="col-md-6 events-title-subtitle">';
                                                    echo '<h4><a href="'.esc_url(get_permalink(get_the_ID())).'">'.get_the_title().'</a></h4>';
                                                    echo '<p>'.strip_tags(modeltheme_excerpt_limit($content, 8)).'</p>';
                                                echo '</div>';
                                                echo '<div class="col-md-2 event-meta text-center">';
                                                    echo '<div class="mt-event-location">'.esc_html($location).'</div>';
                                                echo '</div>';
                                                echo '<div class="col-md-2 event-meta text-center">';
                                                    echo '<div class="mt-event-cat">'.get_the_term_list( get_the_ID(), 'mt-event-category', '', '' ).'</div>';
                                                echo '</div>';
                                                echo '<div class="col-md-2 event-meta text-center">';
                                                    echo '<div class="mt-event-date">'.date(get_option('date_format'), strtotime($date)).'</div>';
                                                echo '</div>';
                                            echo '</div>';

                                        echo '</div>';
                                    echo '</div>';
                                echo '</div>';
                            ?>

                        <?php endwhile; ?>
                        
                    </div>
                <?php else : ?>
                    <?php get_template_part( 'content', 'none' ); ?>
                <?php endif; ?>

                <?php 
                $wp_query = new WP_Query($args);
                global  $wp_query;
                if ($wp_query->max_num_pages != 1) { ?>                
                <div class="modeltheme-pagination-holder col-md-12">           
                    <div class="modeltheme-pagination pagination">           
                        <?php the_posts_pagination(); ?>
                    </div>
                </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>



<?php
get_footer();
?>