<?php
/*
* Template Name: Numismatico Whitepapers List
*/


get_header(); 

    echo do_shortcode(get_post_field('post_content', get_the_ID())); ?>

    <!-- Page content -->
    <?php
    wp_reset_postdata();
    if ( get_query_var('paged') ) {
        $paged = get_query_var('paged');
    } elseif ( get_query_var('page') ) {
        $paged = get_query_var('page');
    } else {
       $paged = 1;
    }
    $args = array(
        'post_type'        => 'mt_listing',
        'post_status'      => 'publish',
        'paged'            => $paged,
    );
    $posts = new WP_Query( $args );

    ?>
    <!-- Blog content -->
    <div class="container ico-whitepapers-posts high-padding spacing_mobile_40 spacing_tablets_60">
        
        <div class="row">

            <div class="col-md-12 main-content">

            <?php if ( $posts->have_posts() ) : ?>
                <?php /* Start the Loop */ ?>
                <div class="row">

                    <?php /* Start the Loop */ ?>
                    <?php $i=1; ?>
                    <?php while ( $posts->have_posts() ) : $posts->the_post(); ?>

                        <?php 
                        // BLOGLOOP-V1
                        $mt_listing_whitepaper_button = get_post_meta( get_the_ID(), 'mt_listing_whitepaper_button', true );
                        $mt_listing_ticker = get_post_meta( get_the_ID(), 'mt_listing_ticker', true );
                        $mt_select_font = get_post_meta( get_the_ID(), 'mt_select_font', true );
                        $mt_font_cryptocoins_icons = get_post_meta( get_the_ID(), 'mt_font_cryptocoins_icons', true );
                        $mt_font_awesome_icons = get_post_meta( get_the_ID(), 'mt_font_awesome_icons', true );
                        $mt_font_simple_line = get_post_meta( get_the_ID(), 'mt_font_simple_line_icons', true );
                        $my_excerpt = get_the_excerpt( $posts->ID); 
                        // THUMBNAIL
                        $post_img = '';
                        $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'numismatico_post_archived' );
                        if ($thumbnail_src) {
                            $post_img = '<img class="blog_post_image" src="'. esc_url($thumbnail_src[0]) . '" alt="'.get_the_title().'" />';
                        }
                        ?>

                        <article id="post-<?php the_ID(); ?>" <?php post_class('single-post col-md-3'); ?> > 
                            <div class="blog_custom">

                                <?php /*POST THUMBNAIL*/ ?>
                                <div class="ico-icon">
                                    <!-- POST THUMBNAIL -->
                                    <a href="<?php echo esc_url(get_the_permalink()); ?>" class="relative">
                                        <?php if (!empty($post_img)) { ?>
                                          <?php echo wp_kses_post($post_img); ?>
                                        <?php } else { ?>
                                          <div class="featured-icon">
                                            <?php if (isset($mt_select_font) && $mt_select_font == 'cryptocoins_icons') { ?>
                                              <?php if($mt_font_cryptocoins_icons) { ?>
                                                <i class="<?php echo esc_attr($mt_font_cryptocoins_icons); ?>"></i>
                                              <?php } ?>
                                            <?php } elseif (isset($mt_select_font) && $mt_select_font == 'font_awesome_icons') { ?>
                                              <?php if($mt_font_awesome_icons) { ?>
                                                <i class="<?php echo esc_attr($mt_font_awesome_icons); ?>"></i>
                                              <?php } ?>
                                            <?php } elseif (isset($mt_select_font) && $mt_select_font == 'simple_line_icons') { ?>
                                              <?php if($mt_font_simple_line) { ?>
                                                <i class="<?php echo esc_attr($mt_font_simple_line); ?>"></i>
                                              <?php } ?>
                                            <?php } ?>
                                          </div>
                                        <?php } ?>
                                    </a>
                                </div>

                                <!-- POST DETAILS -->
                                <div class="post-details">
                                    <div class="post-details-padding">
                                        <!-- POST TITLE -->
                                        <h4 class="post-name">
                                            <a title="<?php the_title_attribute() ?>" href="<?php echo esc_url(get_the_permalink()); ?>">
                                                <!-- POST TITLE -->
                                                <?php the_title() ?> 
                                            </a>
                                        </h4>
                                        <p class="post-token-name">
                                             <?php 
                                                if(isset($mt_listing_ticker) && !empty($mt_listing_ticker)){
                                                    echo " (".esc_html($mt_listing_ticker).")";
                                                } ?>
                                        </p>
                                        <p class="post-details-content">
                                            <?php echo strip_tags(numismatico_excerpt_limit($my_excerpt, 5)).' (...)' ?>
                                        </p>
                                    </div>
                                </div>

                                <!-- POST BUTTON -->
                                <div class="post-button">
                                <!-- POST CONTENT / EXCERPT -->
                                <?php if (!empty($mt_listing_whitepaper_button)) { ?>
                                        <a target="_blank" href="<?php echo esc_url($mt_listing_whitepaper_button); ?>">
                                            <i class="fa fa-file-text-o" aria-hidden="true"></i> <?php echo esc_html__( 'View WhitePaper', 'numismatico' ); ?> 
                                        </a>
                                    <?php } ?>
                                </div>
                            </div>
                        </article>
                        <?php if($i % 4 ==0){ ?>
                            <div class="clearfix"></div>
                        <?php } ?>
                        <?php $i++; ?>
                    <?php endwhile; ?>
                    
                </div>
            <?php else : ?>
                <?php get_template_part( 'content', 'none' ); ?>
            <?php endif; ?>
            
            <div class="clearfix"></div>

            <?php 
            $wp_query = new WP_Query($args);
            global  $wp_query;
            if ($wp_query->max_num_pages != 1) { ?>                
            <div class="modeltheme-pagination-holder col-md-12">           
                <div class="modeltheme-pagination pagination">           
                    <?php the_posts_pagination(); ?>
                </div>
            </div>
            <?php } ?>
            </div>

        </div>
    </div>


<?php
get_footer();
?>