<?php 

require_once(__DIR__.'/../vc-shortcodes.inc.arrays.php');


/**

||-> Shortcode: Events Timeline

*/
function modeltheme_shortcode_events($params, $content) {
    extract( shortcode_atts( 
        array(
            'number'                        =>'',
            'mtlistings_style_variant'      =>'',
            'animation'                     =>'',
            'title_bg'                      =>'',
            'title_color'                   =>'',
            'extra_class'                   =>'',
            'items_per_row'                 =>'',
        ), $params ) );


    $args_recenposts = array(
        'posts_per_page'   => $number,
        'post_type'        => 'mt_event',
        'order'            => 'ASC',
        'orderby'          => 'meta_value_num',
        'meta_query' => array(
            array(
                'key' => 'mt_event_date',
                'compare' => '<=',
                'value' => time(), // Current timestamp.

            ),
        ),
        'post_status'      => 'publish' 
    ); 
    $recentposts = get_posts($args_recenposts);

        $last_item_row = '';
      if ($items_per_row == 'col-md-12') {
        $items_per_row_new = 'row-1event';
      }elseif ($items_per_row == 'col-md-6') {
        $items_per_row_new = 'row-2events';
        // if ($i%2 == 0) {
        //   $last_item_row = 'last_item_row';
        // }
      }elseif ($items_per_row == 'col-md-4') {
        $items_per_row_new = 'row-3events';
        // if ($i%3 == 0) {
        //   $last_item_row = 'last_item_row';
        // }
      }elseif ($items_per_row == 'col-md-3') {
        $items_per_row_new = 'row-4events';
        // if ($i%4 == 0) {
        //   $last_item_row = 'last_item_row';
        // }
      }

    $html = '';

        $html .= '<div class="events-content mt-events-block '.$mtlistings_style_variant.' '.$extra_class.'">';

                $html .= '<div class="mt-single-event-head '.$items_per_row_new.'" style="background: '.$title_bg.'">
                               <div class="mt-single-event-innerhead">
                                  <div class="col-md-1 mt-single-event-innerhead-left"><p class="no-margin" style="color: '.$title_color.';">Event</p></div>
                                  <div class="col-md-11 mt-single-event-innerhead-right">
                                     <div class="row">
                                        <div class="col-md-6 events-title-subtitle"></div>
                                        <div class="col-md-2 text-left">
                                           <p class="no-margin" style="color: '.$title_color.';">Location</p>
                                        </div>
                                        <div class="col-md-2 text-left">
                                           <p class="no-margin" style="color: '.$title_color.';">Category</p>
                                        </div>
                                        <div class="col-md-2 event-meta text-left">
                                           <p class="no-margin" style="color: '.$title_color.';">Date</p>
                                        </div>
                                     </div>
                                  </div>
                               </div>
                            </div>
                            <div class="mt-single-event-list row">';


            foreach ($recentposts as $post) {
                #Content
                $content_post = get_post($post->ID);
                $content = $content_post->post_content;
                $content = apply_filters('the_content', $content);
                $content = str_replace(']]>', ']]&gt;', $content);
                $date = get_post_meta( $post->ID, 'mt_event_date', true );
                $location = get_post_meta( $post->ID, 'mt_event_location', true );
                $featured_status = get_post_meta( $post->ID, 'mt_event_featured_status', true );
                $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ),'mt_390x275' );

                $sponsored = '';
                if (isset($featured_status) && $featured_status != '' && $featured_status == 'yes') {
                    $sponsored = 'sponsored-event';
                }



                $html .= '<div class="mt-single-event '.$items_per_row.' '.$items_per_row_new.' '.$last_item_row.' '.esc_attr($sponsored).'" data-date="'.date("d/m/Y", strtotime($date)).'">';
                    $html .= '<div class="mt-single-event-inner relative '.esc_attr($sponsored).'">';
                        if (isset($featured_status) && $featured_status != '' && $featured_status == 'yes') {
                            $html .= '<div class="event-box-corner"></div>';
                        }


                        if (($items_per_row == 'col-md-12')) {
                          $html .= '<div class="col-md-1 timeline_image_holder">';
                            if($thumbnail_src) { 
                                $html .= '<a href="'.get_permalink($post->ID).'"><img src="'. $thumbnail_src[0] . '" alt="'. $post->post_title .'" /></a>';
                            }else{ 
                                $html .= '<a href="'.get_permalink($post->ID).'"><img src="http://placehold.it/390x275" alt="'. $post->post_title .'" /></a>'; 
                            }
                        $html .= '</div>';
                        $html .= '<div class="col-md-11 timeline_text_holder">';

                            $html .= '<div class="row">';
                                $html .= '<div class="col-md-6 events-title-subtitle">';
                                    $html .= '<h4><a href="'.get_permalink($post->ID).'">'.$post->post_title.'</a></h4>';
                                    $html .= '<p>'.strip_tags(modeltheme_excerpt_limit($content, 12)).' (...)</p>';
                                $html .= '</div>';
                                $html .= '<div class="col-md-2 event-meta text-left">';
                                    $html .= '<div class="mt-event-location">'.$location.'</div>';
                                $html .= '</div>';
                                $html .= '<div class="col-md-2 event-meta text-left">';
                                    $html .= '<div class="mt-event-cat">'.get_the_term_list( $post->ID, 'mt-event-category', '', '' ).'</div>';
                                $html .= '</div>';
                                $html .= '<div class="col-md-2 event-meta text-left">';
                                    $html .= '<div class="mt-event-date">'.date(get_option('date_format'), strtotime($date)).'</div>';
                                $html .= '</div>';
                            $html .= '</div>';


                        }elseif ($items_per_row == 'col-md-6') {
                          $html .= '<div class="col-md-4 timeline_image_holder row">';
                            if($thumbnail_src) { 
                                $html .= '<a href="'.get_permalink($post->ID).'"><img src="'. $thumbnail_src[0] . '" alt="'. $post->post_title .'" /></a>';
                            }else{ 
                                $html .= '<a href="'.get_permalink($post->ID).'"><img src="http://placehold.it/390x275" alt="'. $post->post_title .'" /></a>'; 
                            }
                        $html .= '</div>';
                        $html .= '<div class="col-md-8 timeline_text_holder">';

                            $html .= '<div class="row">';
                                $html .= '<div class="col-md-12 event-meta text-left">';
                                    $html .= '<div class="mt-event-location">'.$location.'</div> - <div class="mt-event-date">'.date(get_option('date_format'), strtotime($date)).'</div>';
                                $html .= '</div>';
                                $html .= '<div class="col-md-12 events-title-subtitle">';
                                    $html .= '<h4><a href="'.get_permalink($post->ID).'">'.$post->post_title.'</a></h4>';
                                    $html .= '<p>'.strip_tags(modeltheme_excerpt_limit($content, 12)).' (...)</p>';
                                $html .= '</div>';
                            $html .= '</div>';


                        }elseif ($items_per_row == 'col-md-4') {
                          $html .= '<div class="col-md-5 timeline_image_holder row">';
                            if($thumbnail_src) { 
                                $html .= '<a href="'.get_permalink($post->ID).'"><img src="'. $thumbnail_src[0] . '" alt="'. $post->post_title .'" /></a>';
                            }else{ 
                                $html .= '<a href="'.get_permalink($post->ID).'"><img src="http://placehold.it/390x275" alt="'. $post->post_title .'" /></a>'; 
                            }
                        $html .= '</div>';
                        $html .= '<div class="col-md-7 timeline_text_holder">';

                            $html .= '<div class="row">';
                                $html .= '<div class="col-md-12 event-meta text-left">';
                                    $html .= '<div class="mt-event-location">'.$location.'</div>';
                                $html .= '</div>';
                                $html .= '<div class="col-md-12 events-title-subtitle">';
                                    $html .= '<h4><a href="'.get_permalink($post->ID).'">'.$post->post_title.'</a></h4>';
                                $html .= '</div>';
                            $html .= '</div>';


                        }elseif ($items_per_row == 'col-md-3') {
                          $html .= '<div class="col-md-12 timeline_image_holder">';
                            if($thumbnail_src) { 
                                $html .= '<a href="'.get_permalink($post->ID).'"><img src="'. $thumbnail_src[0] . '" alt="'. $post->post_title .'" /></a>';
                            }else{ 
                                $html .= '<a href="'.get_permalink($post->ID).'"><img src="http://placehold.it/390x275" alt="'. $post->post_title .'" /></a>'; 
                            }
                        $html .= '</div>';
                        $html .= '<div class="col-md-12 timeline_text_holder">';

                            $html .= '<div class="row">';
                                $html .= '<div class="col-md-12 events-title-subtitle">';
                                    $html .= '<h4><a href="'.get_permalink($post->ID).'">'.$post->post_title.'</a></h4>';
                                $html .= '</div>';
                                $html .= '<div class="col-md-12 event-meta text-left">';
                                    $html .= '<div class="mt-event-location">'.$location.'</div>';
                                $html .= '</div>';
                                $html .= '<div class="col-md-12 event-meta text-left">';
                                    $html .= '<div class="mt-event-date">'.date(get_option('date_format'), strtotime($date)).'</div>';
                                $html .= '</div>';
                            $html .= '</div>';
                        }

                        // $html .= '<div class="col-md-1 timeline_image_holder">';
                        //     if($thumbnail_src) { 
                        //         $html .= '<a href="'.get_permalink($post->ID).'"><img src="'. $thumbnail_src[0] . '" alt="'. $post->post_title .'" /></a>';
                        //     }else{ 
                        //         $html .= '<a href="'.get_permalink($post->ID).'"><img src="http://placehold.it/390x275" alt="'. $post->post_title .'" /></a>'; 
                        //     }
                        // $html .= '</div>';
                        // $html .= '<div class="col-md-11 timeline_text_holder">';

                        //     $html .= '<div class="row">';
                        //         $html .= '<div class="col-md-6 events-title-subtitle">';
                        //             $html .= '<h4><a href="'.get_permalink($post->ID).'">'.$post->post_title.'</a></h4>';
                        //             $html .= '<p>'.strip_tags(modeltheme_excerpt_limit($content, 12)).' (...)</p>';
                        //         $html .= '</div>';
                        //         $html .= '<div class="col-md-2 event-meta text-left">';
                        //             $html .= '<div class="mt-event-location">'.$location.'</div>';
                        //         $html .= '</div>';
                        //         $html .= '<div class="col-md-2 event-meta text-left">';
                        //             $html .= '<div class="mt-event-cat">'.get_the_term_list( $post->ID, 'mt-event-category', '', '' ).'</div>';
                        //         $html .= '</div>';
                        //         $html .= '<div class="col-md-2 event-meta text-left">';
                        //             $html .= '<div class="mt-event-date">'.date(get_option('date_format'), strtotime($date)).'</div>';
                        //         $html .= '</div>';
                        //     $html .= '</div>';



                        $html .= '</div>';
                    $html .= '</div>';
                $html .= '</div>';

            }
            $html .= '</div>';
        $html .= '</div>';

    return $html;
}
add_shortcode('shortcode_events_timeline', 'modeltheme_shortcode_events');




/**

||-> Map Shortcode in Visual Composer with: vc_map();

*/
if ( is_plugin_active( 'js_composer/js_composer.php' ) ) {
    vc_map( 
        array(
            "name" => esc_attr__("MT - Events Timeline", 'modeltheme'),
            "base" => "shortcode_events_timeline",
            "category" => esc_attr__('MT: ModelTheme', 'modeltheme'),
            "icon" => "smartowl_shortcode",
            "params" => array(
                array(
                   "group" => "Options",
                   "type" => "textfield",
                   "holder" => "div",
                   "class" => "",
                   "heading" => esc_attr__("Number of events to show", 'modeltheme'),
                   "param_name" => "number",
                   "value" => "",
                   "description" => ""
                ),
                 array(
                    "group" => "Options",
                    "type" => "dropdown",
                    "holder" => "div",
                    "class" => "",
                    "heading" => esc_attr__("Style Variant", 'mtlistings'),
                    "param_name" => "mtlistings_style_variant",
                    "std" => '',
                    "description" => "",
                    "value" => array(
                        esc_attr__('Style 1', 'mtlistings')         => 'mtlistings-events-style-v1',
                        esc_attr__('Style 2', 'mtlistings')         => 'mtlistings-events-style-v2',
                    )
                ),
                array(
                    "group" => "Options",
                    "type" => "dropdown",
                    "holder" => "div",
                    "class" => "",
                    "heading" => esc_attr__("Items Per Row", 'mtlistings'),
                    "param_name" => "items_per_row",
                    "std" => '',
                    "description" => "",
                    "value" => array(
                        esc_attr__('1 Items/Row', 'mtlistings')         => 'col-md-12',
                        esc_attr__('2 Items/Row', 'mtlistings')         => 'col-md-6',
                        esc_attr__('3 Items/Row', 'mtlistings')         => 'col-md-4',
                        esc_attr__('4 Items/Row', 'mtlistings')         => 'col-md-3',
                    )
                ),
                array(
                    "group" => "Options",
                    "type" => "textfield",
                    "heading" => __("Extra class name", "modeltheme"),
                    "param_name" => "extra_class",
                    "description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "modeltheme")
                ),
                array(
                    "group" => "Animation",
                    "type" => "dropdown",
                    "heading" => esc_attr__("Animation", 'modeltheme'),
                    "param_name" => "animation",
                    "std" => '',
                    "holder" => "div",
                    "class" => "",
                    "description" => "",
                    "value" => $animations_list
                ),
                array(
                    "group" => "Styling",
                    "type" => "colorpicker",
                    "class" => "",
                    "heading" => esc_attr__( "Title Background", 'mtlistings' ),
                    "param_name" => "title_bg",
                    "value" => ""
                ),
                array(
                    "group" => "Styling",
                    "type" => "colorpicker",
                    "class" => "",
                    "heading" => esc_attr__( "Title color", 'mtlistings' ),
                    "param_name" => "title_color",
                    "value" => ""
                ),
            )
        )
    );
}
?>