<?php 
/* ------------------------------------------------------------------
[Modeltheme - SHORTCODES]

[Table of contents]
    Recent Tweets
    Contact Form
    Recent Posts
    Featured Post with thumbnail
    Subscribe form
    Skill
    Pricing tables
    Jumbot
    Alert
    Progress bars
    Custom content
    Responsive video (YouTube)
    Heading With Border
    Testimonials
    List group
    Thumbnails custom content
    Section heading with title and subtitle
    Section heading with title
    Heading with bottom border
    Call to action
    Blog posts
    Social Media
    Quotes
    Banner
    Our Services
    Quotes Slider
    Courses
------------------------------------------------------------------ */



include_once( ABSPATH . 'wp-admin/includes/plugin.php' );


include_once( 'mt-members/mt-members-slider.php' ); # Members 01
include_once( 'mt-services/mt_custom_service.php' ); # Services 03
include_once( 'mt-contact/mt-contact01.php' );
include_once( 'mt-blog-posts/mt-blogpost01.php' ); # Blog Post
include_once( 'mt-blog-posts/mt-blogpost02.php' ); # Blog Post Version 2
include_once( 'mt-testimonials/mt-testimonials01.php' ); # Testimonials 01
include_once( 'mt-testimonials/mt-testimonials02.php' ); # Testimonials 02
include_once( 'mt-clients/mt-clients.php' ); # Clients
include_once( 'mt-title-subtitle/mt-title-subtitle.php' ); # Title Subtitle
include_once( 'mt-social-icons/mt-social-icons.php' ); # Social Icons
include_once( 'mt-social-icon/mt-social-icon.php' ); # Social Icons
include_once( 'mt-featured-post/mt-featured-post.php' ); # Featured Post
include_once( 'mt-skills/mt-skills.php' ); # Skills
include_once( 'mt-pricing-tables/mt-pricing-tables.php' ); # Pricing Tables
include_once( 'mt-countdown/mt-countdown.php' ); # Countdown
include_once( 'mt-icon-list-item/mt-icon-list-item.php' ); # Mailchimp Subscribe Form
include_once( 'mt-typed-text/mt-typed-text.php' ); # Typed text
include_once( 'mt-video/mt-video.php' ); # Video
include_once( 'mt-mailchimp-subscribe-form/mt-mailchimp-subscribe-form.php' ); # Mailchimp Subscribe Form
include_once( 'mt-featured-product/mt-featured-product.php' ); # Featured Product
include_once( 'mt-sharer/mt-sharer.php' ); # Featured Product
include_once( 'mt-coundown-version2/mt-coundown-version2.php' ); # CountDown Version 2
include_once( 'mt-particles/mt-particles.php' ); # CountDown Version 2
include_once( 'mt-timeline/mt-timeline.php' ); # Timeline
include_once( 'mt-timeline/mt-timeline-version2.php' ); # Timeline version2
include_once( 'mt-tabs/mt-tabs.php' ); # Tabs
include_once( 'mt-timeline/mt_timeline_horizontal.php' ); # Timeline Horizontal
include_once( 'mt-category-products/mt-category-products.php' ); # Category Products
include_once( 'mt-events/shortcodes.mt-events.php' ); # Events


// BOOTSTRAP ELEMENTS
include_once( 'mt-bootstrap-alert/mt-bootstrap-alert.php' ); # Bootstrap Alerts
include_once( 'mt-bootstrap-jumbotron/mt-bootstrap-jumbotron.php' ); # Bootstrap Jumbotron
include_once( 'mt-bootstrap-panel/mt-bootstrap-panel.php' ); # Bootstrap Panel
include_once( 'mt-panel/mt-panel.php' ); # Panel 2
include_once( 'mt-bootstrap-thumbnails-custom-content/mt-bootstrap-thumbnails-custom-content.php' ); # Bootstrap Thumbnails Custom Content
include_once( 'mt-bootstrap-listgroup/mt-bootstrap-listgroup.php' ); # Bootstrap List Group
include_once( 'mt-bootstrap-button/mt-bootstrap-button.php' ); # Bootstrap Buttons
include_once( 'mt-bubble-box/mt-bubble-box.php' ); # Bootstrap Buttons



/* Custom class for login/register page to avoid duplicate id's */
function shortcode_class( $class ) {
    global $post;
    if( isset($post->post_content) && has_shortcode( $post->post_content, 'login-form' ) ) {
        $class[] = 'login-register-page';
    }
    return $class;
}
add_filter( 'body_class', 'shortcode_class' );


add_shortcode( 'login-form', 'my_login_form_shortcode' );

function my_login_form_shortcode() {

    $content = '';
    if ( is_user_logged_in() ) {
        $content .= '<div class="logged-in-shortcode">';
            $content .= '<div class="logged-in-content-shortcode">';
                $content .= '<h3'.esc_html__('>You are already logged in as ','modeltheme').wp_get_current_user()->user_login.'!</h3>';
                $content .= '<a class="back-home" href="'.esc_url(site_url()).'">'.esc_html__('Back to homepage','modeltheme').'</a>';
            $content .= '</div>';
        $content .= '</div>';
        return $content;
    } else {
        $content .= '<div class="login-register-shortcode">';
            $content .= '<div id="login-content-shortcode">';
                $content .= '<h3 class="relative">'.esc_html__('Login to Your Account','modeltheme').'</h3>';
                $content .= '<div class="login-content-row row">';
                    $content .= '<div class="col-md-12">';
                        $content .= wp_login_form(array( 'echo' => false ));
                        if ( class_exists( 'UM_Functions' ) ) {
                            $content .= '<a class="btn btn-register-shortcode" id="register-btn-shortcode">'.esc_html__('Register','modeltheme').'</a>';
                        }
                    $content .= '</div>';
                $content .= '</div>';
            $content .= '</div>';
            $content .= '<div id="register-content-shortcode">';
                $content .= '<h3 class="relative">'.esc_html__('Personal Details','modeltheme').'</h3>';
                $content .= '<div class="register-content-row row">';
                    $content .= '<div class="col-md-12">';
                        $content .= do_shortcode('[ultimatemember form_id=7]');
                    $content .= '</div>';
                $content .= '</div>';
            $content .= '</div>';
        $content .= '</div>';
        return $content;
    }
}


?>