<?php 
/**
* 
* [Widgets]
* 
**/
/* ========= social_icons ===================================== */
class numismatico_address_social_icons extends WP_Widget {
    function __construct() {
        parent::__construct('numismatico_address_social_icons', esc_attr__('MT - Contact + Social links', 'modeltheme'),array( 'description' => esc_attr__( 'MT - Contact information + Social icons', 'modeltheme' ), ) );
    }
    public function widget( $args, $instance ) {
        $widget_title = $instance[ 'widget_title' ];
        $widget_contact_details = $instance['widget_contact_details'] ? 'true' : 'false';
        $widget_social_icons = $instance['widget_social_icons'] ? 'true' : 'false';
        echo  $args['before_widget']; ?>
        <div class="sidebar-social-networks address-social-links">
            <?php if($widget_title) { ?>
               <h3 class="widget-title"><?php echo esc_attr($widget_title); ?></h3>
            <?php } ?>
            <?php if('on' == $instance['widget_contact_details']) { ?>
                <div class="contact-details">
                    <p><i class="fa fa-phone" aria-hidden="true"></i><a href="tel:<?php echo esc_attr( numismatico_redux('mt_contact_phone')); ?>"><?php echo esc_attr( numismatico_redux('mt_contact_phone')); ?></a></p>
                    <p><i class="fa fa-envelope" aria-hidden="true"></i><a href="mailto:<?php echo esc_attr( numismatico_redux('mt_contact_email')); ?>"><?php echo esc_attr( numismatico_redux('mt_contact_email')); ?></a></p>
                    <p><i class="fa fa-map-marker" aria-hidden="true"></i><?php echo esc_attr( numismatico_redux('mt_contact_address')); ?></p>
                </div>
            <?php } ?>
            <?php if('on' == $instance['widget_social_icons']) { ?>
                <ul class="social-links">
                <?php if ( numismatico_redux('mt_social_fb') && numismatico_redux('mt_social_fb') != '' ) { ?>
                    <li><a target="_blank" href="<?php echo esc_attr( numismatico_redux('mt_social_fb') ) ?>"><i class="fa fa-facebook"></i></a></li>
                <?php } ?>
                <?php if ( numismatico_redux('mt_social_tw') && numismatico_redux('mt_social_tw') != '' ) { ?>
                    <li><a target="_blank" href="<?php echo esc_url( numismatico_redux('mt_social_tw') ) ?>"><i class="fa fa-twitter"></i></a></li>
                <?php } ?>
                <?php if ( numismatico_redux('mt_social_youtube') && numismatico_redux('mt_social_youtube') != '' ) { ?>
                    <li><a target="_blank" href="<?php echo esc_url( numismatico_redux('mt_social_youtube') ) ?>"><i class="fa fa-youtube"></i></a></li>
                <?php } ?>
                <?php if ( numismatico_redux('mt_social_pinterest') && numismatico_redux('mt_social_pinterest') != '' ) { ?>
                    <li><a target="_blank" href="<?php echo esc_url( numismatico_redux('mt_social_pinterest') ) ?>"><i class="fa fa-pinterest"></i></a></li>
                <?php } ?>
                <?php if ( numismatico_redux('mt_social_linkedin') && numismatico_redux('mt_social_linkedin') != '' ) { ?>
                    <li><a target="_blank" href="<?php echo esc_url( numismatico_redux('mt_social_linkedin') ) ?>"><i class="fa fa-linkedin"></i></a></li>
                <?php } ?>
                <?php if ( numismatico_redux('mt_social_skype') && numismatico_redux('mt_social_skype') != '' ) { ?>
                    <li><a target="_blank" href="<?php echo esc_url( numismatico_redux('mt_social_skype') ) ?>"><i class="fa fa-skype"></i></a></li>
                <?php } ?>
                <?php if ( numismatico_redux('mt_social_instagram') && numismatico_redux('mt_social_instagram') != '' ) { ?>
                    <li><a target="_blank" href="<?php echo esc_url( numismatico_redux('mt_social_instagram') ) ?>"><i class="fa fa-instagram"></i></a></li>
                <?php } ?>
                <?php if ( numismatico_redux('mt_social_dribbble') && numismatico_redux('mt_social_dribbble') != '' ) { ?>
                    <li><a target="_blank" href="<?php echo esc_url( numismatico_redux('mt_social_dribbble') ) ?>"><i class="fa fa-dribbble"></i></a></li>
                <?php } ?>
                <?php if ( numismatico_redux('mt_social_deviantart') && numismatico_redux('mt_social_deviantart') != '' ) { ?>
                    <li><a target="_blank" href="<?php echo esc_url( numismatico_redux('mt_social_deviantart') ) ?>"><i class="fa fa-deviantart"></i></a></li>
                <?php } ?>
                <?php if ( numismatico_redux('mt_social_digg') && numismatico_redux('mt_social_digg') != '' ) { ?>
                    <li><a target="_blank" href="<?php echo esc_url( numismatico_redux('mt_social_digg') ) ?>"><i class="fa fa-digg"></i></a></li>
                <?php } ?>
                <?php if ( numismatico_redux('mt_social_flickr') && numismatico_redux('mt_social_flickr') != '' ) { ?>
                    <li><a target="_blank" href="<?php echo esc_url( numismatico_redux('mt_social_flickr') ) ?>"><i class="fa fa-flickr"></i></a></li>
                <?php } ?>
                <?php if ( numismatico_redux('mt_social_stumbleupon') && numismatico_redux('mt_social_stumbleupon') != '' ) { ?>
                    <li><a target="_blank" href="<?php echo esc_url( numismatico_redux('mt_social_stumbleupon') ) ?>"><i class="fa fa-stumbleupon"></i></a></li>
                <?php } ?>
                <?php if ( numismatico_redux('mt_social_tumblr') && numismatico_redux('mt_social_tumblr') != '' ) { ?>
                    <li><a target="_blank" href="<?php echo esc_url( numismatico_redux('mt_social_tumblr') ) ?>"><i class="fa fa-tumblr"></i></a></li>
                <?php } ?>
                <?php if ( numismatico_redux('mt_social_vimeo') && numismatico_redux('mt_social_vimeo') != '' ) { ?>
                    <li><a target="_blank" href="<?php echo esc_url( numismatico_redux('mt_social_vimeo') ) ?>"><i class="fa fa-vimeo-square"></i></a></li>
                <?php } ?>
                </ul>
            <?php } ?>
            
        </div>
        <?php echo  $args['after_widget'];
    }
    public function form( $instance ) {
        # Widget Title
        if ( isset( $instance[ 'widget_title' ] ) ) {
            $widget_title = $instance[ 'widget_title' ];
        } else {
            $widget_title = esc_attr__( 'Social icons', 'modeltheme' );
        }
        $instance['widget_contact_details'] = ( ! empty( $instance['widget_contact_details'] ) ) ?  $instance['widget_contact_details']  : '';
        $instance['widget_social_icons'] = ( ! empty( $instance['widget_social_icons'] ) ) ?  $instance['widget_social_icons']  : '';
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'widget_title' )); ?>"><?php esc_attr_e( 'Widget Title:','modeltheme' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'widget_title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'widget_title' )); ?>" type="text" value="<?php echo esc_attr( $widget_title ); ?>">
        </p>
        <p>
            <input type="checkbox" <?php checked($instance['widget_contact_details'], 'on'); ?> id="<?php echo esc_attr($this->get_field_name('widget_contact_details')); ?>" name="<?php echo esc_attr($this->get_field_name('widget_contact_details')); ?>" /> 
            <label for="<?php echo esc_attr($this->get_field_name('widget_contact_details')); ?>"><?php esc_attr_e( 'Show contact informations box','modeltheme' ); ?></label>
        </p>
        <p>
            <input type="checkbox" <?php checked($instance['widget_social_icons'], 'on'); ?> id="<?php echo esc_attr($this->get_field_name('widget_social_icons')); ?>" name="<?php echo esc_attr($this->get_field_name('widget_social_icons')); ?>" /> 
            <label for="<?php echo esc_attr($this->get_field_name('widget_social_icons')); ?>"><?php esc_attr_e( 'Show social icons','modeltheme' ); ?></label>
        </p>
        <p><?php esc_attr_e( '* Social Network account must be set from MT - Theme Panel.','modeltheme' ); ?></p>
        <?php 
    }
    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['widget_title'] = ( ! empty( $new_instance['widget_title'] ) ) ?  $new_instance['widget_title']  : '';
        $instance['widget_contact_details'] = ( ! empty( $new_instance['widget_contact_details'] ) ) ?  $new_instance['widget_contact_details']  : '';
        $instance['widget_social_icons'] = ( ! empty( $new_instance['widget_social_icons'] ) ) ?  $new_instance['widget_social_icons']  : '';
        return $instance;
    }
}


/* ========= numismatico_recent_entries_with_thumbnail ===================================== */
class numismatico_recent_entries_with_thumbnail extends WP_Widget {
    /**
     * Register widget with WordPress.
     */
    function __construct() {
        parent::__construct('numismatico_recent_entries_with_thumbnail', esc_attr__('MT - Recent Posts with thumbnails', 'modeltheme'),array( 'description' => esc_attr__( 'MT - Recent Posts with thumbnails', 'modeltheme' ), ) );
    }
    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget( $args, $instance ) {
        $recent_posts_title = $instance[ 'recent_posts_title' ];
        $recent_posts_number = $instance[ 'recent_posts_number' ];
        echo  $args['before_widget'];
        $args_recenposts = array(
                'posts_per_page'   => $recent_posts_number,
                'orderby'          => 'post_date',
                'order'            => 'ASC',
                'post_type'        => 'post',
                'post_status'      => 'publish' 
                );
        $recentposts = get_posts($args_recenposts);
        $myContent  = "";
        $myContent .= '<h3 class="widget-title">'.$recent_posts_title.'</h3>';
        $myContent .= '<ul>';
        foreach ($recentposts as $post) {
            $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ),'numismatico_post_widget_pic100x100' );
            $myContent .= '<li class="row">';
                $myContent .= '<div class="vc_col-md-3 post-thumbnail relative">';
                    $myContent .= '<a href="'. get_permalink($post->ID) .'">';
                        if($thumbnail_src) { $myContent .= '<img src="'. $thumbnail_src[0] . '" alt="'. $post->post_title .'" />';
                        }else{ $myContent .= '<img src="http://placehold.it/100x100" alt="'. $post->post_title .'" />'; }
                        $myContent .= '<div class="thumbnail-overlay absolute">';
                            $myContent .= '<i class="fa fa-plus absolute"></i>';
                        $myContent .= '</div>';
                    $myContent .= '</a>';
                $myContent .= '</div>';
                $myContent .= '<div class="vc_col-md-9 post-details">';
                    $myContent .= '<a href="'. get_permalink($post->ID) .'">'. $post->post_title.'</a>';
                    $myContent .= '<span class="post-date">'.get_the_date(get_option( 'date_format'), $post->ID ).'</span>';
                $myContent .= '</div>';
            $myContent .= '</li>';
        }
        $myContent .= '</ul>';
        echo  $myContent;
        echo  $args['after_widget'];
    }
    /**
     * Back-end widget form.
     *
     * @see WP_Widget::form()
     *
     * @param array $instance Previously saved values from database.
     */
    public function form( $instance ) {
        
        # Widget Title
        if ( isset( $instance[ 'recent_posts_title' ] ) ) {
            $recent_posts_title = $instance[ 'recent_posts_title' ];
        } else {
            $recent_posts_title = esc_attr__( 'Recent posts', 'modeltheme' );
        }
        # Number of posts
        if ( isset( $instance[ 'recent_posts_number' ] ) ) {
            $recent_posts_number = $instance[ 'recent_posts_number' ];
        } else {
            $recent_posts_number = '5';
        }
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'recent_posts_title' )); ?>"><?php esc_attr_e( 'Widget Title:','modeltheme' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'recent_posts_title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'recent_posts_title' )); ?>" type="text" value="<?php echo esc_attr( $recent_posts_title ); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'recent_posts_number' )); ?>"><?php esc_attr_e( 'Number of posts:','modeltheme' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'recent_posts_number' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'recent_posts_number' )); ?>" type="text" value="<?php echo esc_attr( $recent_posts_number ); ?>">
        </p>
        <?php 
    }
    /**
     * Sanitize widget form values as they are saved.
     *
     * @see WP_Widget::update()
     *
     * @param array $new_instance Values just sent to be saved.
     * @param array $old_instance Previously saved values from database.
     *
     * @return array Updated safe values to be saved.
     */
    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['recent_posts_title'] = ( ! empty( $new_instance['recent_posts_title'] ) ) ?  $new_instance['recent_posts_title']  : '';
        $instance['recent_posts_number'] = ( ! empty( $new_instance['recent_posts_number'] ) ) ? strip_tags( $new_instance['recent_posts_number'] ) : '';
        return $instance;
    }
}


/* ========= numismatico_post_thumbnails_slider ===================================== */
class numismatico_post_thumbnails_slider extends WP_Widget {
    /**
     * Register widget with WordPress.
     */
    function __construct() {
        parent::__construct('numismatico_post_thumbnails_slider', esc_attr__('MT - Post thumbnails slider', 'modeltheme'),array( 'description' => esc_attr__( 'MT - Post thumbnails slider', 'modeltheme' ), ) );
    }
    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget( $args, $instance ) {
        $recent_posts_title = $instance[ 'recent_posts_title' ];
        $recent_posts_number = $instance[ 'recent_posts_number' ];
        echo  $args['before_widget'];
        $args_recenposts = array(
                'posts_per_page'   => $recent_posts_number,
                'orderby'          => 'post_date',
                'order'            => 'DESC',
                'post_type'        => 'post',
                'post_status'      => 'publish' 
                );
        $recentposts = get_posts($args_recenposts);
        $myContent  = "";
        $myContent .= '<h3 class="widget-title">'.$recent_posts_title.'</h3>';
        $myContent .= '<div class="slider_holder relative">';
            $myContent .= '<div class="slider_navigation absolute">';
                $myContent .= '<a class="btn prev pull-left"><i class="fa fa-angle-left"></i></a>';
                $myContent .= '<a class="btn next pull-right"><i class="fa fa-angle-right"></i></a>';
            $myContent .= '</div>';
            $myContent .= '<div class="post_thumbnails_slider owl-carousel owl-theme">';
            foreach ($recentposts as $post) {
                $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ),'numismatico_post_pic700x450' );
                $myContent .= '<div class="item">';
                    $myContent .= '<a href="'. get_permalink($post->ID) .'">';
                        if($thumbnail_src) { $myContent .= '<img src="'. $thumbnail_src[0] . '" alt="'. $post->post_title .'" />';
                        }else{ $myContent .= '<img src="http://placehold.it/700x450" alt="'. $post->post_title .'" />'; }
                    $myContent .= '</a>';
                $myContent .= '</div>';
            }
            $myContent .= '</div>';
        $myContent .= '</div>';
        echo  $myContent;
        echo  $args['after_widget'];
    }
    /**
     * Back-end widget form.
     *
     * @see WP_Widget::form()
     *
     * @param array $instance Previously saved values from database.
     */
    public function form( $instance ) {
        
        # Widget Title
        if ( isset( $instance[ 'recent_posts_title' ] ) ) {
            $recent_posts_title = $instance[ 'recent_posts_title' ];
        } else {
            $recent_posts_title = esc_attr__( 'Post thumbnails slider', 'modeltheme' );
        }
        # Number of posts
        if ( isset( $instance[ 'recent_posts_number' ] ) ) {
            $recent_posts_number = $instance[ 'recent_posts_number' ];
        } else {
            $recent_posts_number = '5';
        }
        $instance['share-facebook'] = ( ! empty( $instance['share-facebook'] ) ) ?  $instance['share-facebook']  : '';
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'recent_posts_title' )); ?>"><?php esc_attr_e( 'Widget Title:','modeltheme' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'recent_posts_title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'recent_posts_title' )); ?>" type="text" value="<?php echo esc_attr( $recent_posts_title ); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'recent_posts_number' )); ?>"><?php esc_attr_e( 'Number of posts:','modeltheme' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'recent_posts_number' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'recent_posts_number' )); ?>" type="text" value="<?php echo esc_attr( $recent_posts_number ); ?>">
        </p>
        <?php 
    }
    /**
     * Sanitize widget form values as they are saved.
     *
     * @see WP_Widget::update()
     *
     * @param array $new_instance Values just sent to be saved.
     * @param array $old_instance Previously saved values from database.
     *
     * @return array Updated safe values to be saved.
     */
    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['recent_posts_title'] = ( ! empty( $new_instance['recent_posts_title'] ) ) ?  $new_instance['recent_posts_title']  : '';
        $instance['recent_posts_number'] = ( ! empty( $new_instance['recent_posts_number'] ) ) ? strip_tags( $new_instance['recent_posts_number'] ) : '';
        return $instance;
    }
}


/* ========= numismatico_social_share ===================================== */
class numismatico_social_share extends WP_Widget {
    function __construct() {
        parent::__construct('numismatico_social_share', esc_attr__('MT - Social Share Icons', 'modeltheme'),array( 'description' => esc_attr__( 'MT - Social Share Icons', 'modeltheme' ), ) );
    }
    public function widget( $args, $instance ) {
        $widget_title = $instance[ 'widget_title' ];
        $facebook = $instance['share-facebook'] ? 'true' : 'false';
        $twitter = $instance['share-twitter'] ? 'true' : 'false';
        $linkedin = $instance['share-linkedin'] ? 'true' : 'false';
        $googleplus = $instance['share-googleplus'] ? 'true' : 'false';
        $digg = $instance['share-digg'] ? 'true' : 'false';
        $pinterest = $instance['share-pinterest'] ? 'true' : 'false';
        $reddit = $instance['share-reddit'] ? 'true' : 'false';
        $stumbleupon = $instance['share-stumbleupon'] ? 'true' : 'false';
        echo  $args['before_widget'];
        $siteurl = get_permalink();
        $sitetitle = get_bloginfo('title');
        $sitedescription = get_bloginfo('description');
        ?>
        <div class="sidebar-share-social-links">
            <h3 class="widget-title"><?php echo  $instance[ 'widget_title' ];?></h3>
            <ul class="share-social-links">
                <?php if('on' == $instance['share-facebook'] ) { ?>
                <li class="facebook">
                    <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo esc_attr($siteurl); ?>" target="_blank"><i class="fa fa-facebook"></i></a>
                </li>
                <?php } if('on' == $instance['share-twitter'] ) {?>
                <li class="twitter">
                    <a href="https://twitter.com/intent/tweet?url=<?php echo esc_attr($siteurl); ?>&amp;text=<?php echo esc_attr($sitedescription); ?>" target="_blank"><i class="fa fa-twitter"></i></a>
                </li>
                <?php } if('on' == $instance['share-linkedin'] ) {?>
                <li class="linkedin">
                    <a href="http://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo esc_attr($siteurl); ?>" target="_blank"><i class="fa fa-linkedin"></i></a>
                </li>
                <?php } if('on' == $instance['share-googleplus'] ) {?>
                <li class="googleplus">
                    <a href="https://plus.google.com/share?url=<?php echo esc_attr($siteurl); ?>" target="_blank"><i class="fa fa-google-plus"></i></a>
                </li>
                <?php } if('on' == $instance['share-digg'] ) {?>
                <li class="digg">
                    <a href="http://www.digg.com/submit?url=<?php echo esc_attr($siteurl); ?>" target="_blank"><i class="fa fa-digg"></i></a>
                </li>
                <?php } if('on' == $instance['share-pinterest'] ) {?>
                <li class="pinterest">
                    <a href="http://pinterest.com/pin/create/button/?url=<?php echo esc_attr($siteurl); ?>&amp;media=<?php echo esc_attr(numismatico_redux('mt_logo', 'url')); ?>&amp;description=<?php echo esc_attr($sitedescription); ?>" target="_blank"><i class="fa fa-pinterest"></i></a>
                </li>
                <?php } if('on' == $instance['share-reddit'] ) {?>
                <li class="reddit">
                    <a href="http://reddit.com/submit?url=<?php echo esc_attr($siteurl); ?>&amp;title=<?php echo esc_attr($sitetitle); ?>" target="_blank"><i class="fa fa-reddit"></i></a>
                </li>
                <?php } if('on' == $instance['share-stumbleupon'] ) {?>
                <li class="stumbleupon">
                    <a href="http://www.stumbleupon.com/submit?url=<?php echo esc_attr($siteurl); ?>&amp;title=<?php echo esc_attr($sitetitle); ?>" target="_blank"><i class="fa fa-stumbleupon"></i></a>
                </li>
                <?php } ?>
            </ul>
        </div>
        <?php 
        echo  $args['after_widget'];
    }
    public function form( $instance ) {
        # Widget Title
        if ( isset( $instance[ 'widget_title' ] ) ) {
            $widget_title = $instance[ 'widget_title' ];
        } else {
            $widget_title = esc_attr__( 'Social icons', 'modeltheme' );
        }
        $instance['share-facebook'] = ( ! empty( $instance['share-facebook'] ) ) ?  $instance['share-facebook']  : '';
        $instance['share-twitter'] = ( ! empty( $instance['share-twitter'] ) ) ?  $instance['share-twitter']  : '';
        $instance['share-linkedin'] = ( ! empty( $instance['share-linkedin'] ) ) ?  $instance['share-linkedin']  : '';
        $instance['share-digg'] = ( ! empty( $instance['share-digg'] ) ) ?  $instance['share-digg']  : '';
        $instance['share-pinterest'] = ( ! empty( $instance['share-pinterest'] ) ) ?  $instance['share-pinterest']  : '';
        $instance['share-reddit'] = ( ! empty( $instance['share-reddit'] ) ) ?  $instance['share-reddit']  : '';
        $instance['share-stumbleupon'] = ( ! empty( $instance['share-stumbleupon'] ) ) ?  $instance['share-stumbleupon']  : '';
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'widget_title' )); ?>"><?php esc_attr_e( 'Widget Title:','modeltheme' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'widget_title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'widget_title' )); ?>" type="text" value="<?php echo esc_attr( $widget_title ); ?>">
        </p>
        <p><?php esc_attr_e( 'Check what Social SHARE Buttons do you want to display','modeltheme' ); ?></p>
        <p>
            <input class="checkboxsocial" type="checkbox" <?php checked($instance['share-facebook'], 'on'); ?> id="<?php echo esc_attr($this->get_field_name('share-facebook')); ?>" name="<?php echo esc_attr($this->get_field_name('share-facebook')); ?>" /> 
            <label for="<?php echo esc_attr($this->get_field_name('share-facebook')); ?>"><?php esc_attr_e( 'Facebook','modeltheme' ); ?></label>
        </p>
        <p>
            <input class="checkboxsocial" type="checkbox" <?php checked($instance['share-twitter'], 'on'); ?> id="<?php echo esc_attr($this->get_field_name('share-twitter')); ?>" name="<?php echo esc_attr($this->get_field_name('share-twitter')); ?>" /> 
            <label for="<?php echo esc_attr($this->get_field_name('share-twitter')); ?>"><?php esc_attr_e( 'Twitter','modeltheme' ); ?></label>
        </p>
        <p>
            <input class="checkboxsocial" type="checkbox" <?php checked($instance['share-linkedin'], 'on'); ?> id="<?php echo esc_attr($this->get_field_name('share-linkedin')); ?>" name="<?php echo esc_attr($this->get_field_name('share-linkedin')); ?>" /> 
            <label for="<?php echo esc_attr($this->get_field_name('share-linkedin')); ?>"><?php esc_attr_e( 'Linkedin','modeltheme' ); ?></label>
        </p>
        <p>
            <input class="checkboxsocial" type="checkbox" <?php checked($instance['share-digg'], 'on'); ?> id="<?php echo esc_attr($this->get_field_name('share-digg')); ?>" name="<?php echo esc_attr($this->get_field_name('share-digg')); ?>" /> 
            <label for="<?php echo esc_attr($this->get_field_name('share-digg')); ?>"><?php esc_attr_e( 'Digg','modeltheme' ); ?></label>
        </p>
        <p>
            <input class="checkboxsocial" type="checkbox" <?php checked($instance['share-pinterest'], 'on'); ?> id="<?php echo esc_attr($this->get_field_name('share-pinterest')); ?>" name="<?php echo esc_attr($this->get_field_name('share-pinterest')); ?>" /> 
            <label for="<?php echo esc_attr($this->get_field_name('share-pinterest')); ?>"><?php esc_attr_e( 'Pinterest','modeltheme' ); ?></label>
        </p>
        <p>
            <input class="checkboxsocial" type="checkbox" <?php checked($instance['share-reddit'], 'on'); ?> id="<?php echo esc_attr($this->get_field_name('share-reddit')); ?>" name="<?php echo esc_attr($this->get_field_name('share-reddit')); ?>" /> 
            <label for="<?php echo esc_attr($this->get_field_name('share-reddit')); ?>"><?php esc_attr_e( 'Reddit','modeltheme' ); ?></label>
        </p>
        <p>
            <input class="checkboxsocial" type="checkbox" <?php checked($instance['share-stumbleupon'], 'on'); ?> id="<?php echo esc_attr($this->get_field_name('share-stumbleupon')); ?>" name="<?php echo esc_attr($this->get_field_name('share-stumbleupon')); ?>" /> 
            <label for="<?php echo esc_attr($this->get_field_name('share-stumbleupon')); ?>"><?php esc_attr_e( 'Stumbleupon','modeltheme' ); ?></label>
        </p>
                
        <?php 
    }
    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['widget_title'] = ( ! empty( $new_instance['widget_title'] ) ) ?  $new_instance['widget_title']  : '';
        
        $instance['share-facebook'] = ( ! empty( $new_instance['share-facebook'] ) ) ?  $new_instance['share-facebook']  : '';
        $instance['share-twitter'] = ( ! empty( $new_instance['share-twitter'] ) ) ?  $new_instance['share-twitter']  : '';
        $instance['share-linkedin'] = ( ! empty( $new_instance['share-linkedin'] ) ) ?  $new_instance['share-linkedin']  : '';
        $instance['share-googleplus'] = ( ! empty( $new_instance['share-googleplus'] ) ) ?  $new_instance['share-googleplus']  : '';
        $instance['share-digg'] = ( ! empty( $new_instance['share-digg'] ) ) ?  $new_instance['share-digg']  : '';
        $instance['share-pinterest'] = ( ! empty( $new_instance['share-pinterest'] ) ) ?  $new_instance['share-pinterest']  : '';
        $instance['share-reddit'] = ( ! empty( $new_instance['share-reddit'] ) ) ?  $new_instance['share-reddit']  : '';
        $instance['share-stumbleupon'] = ( ! empty( $new_instance['share-stumbleupon'] ) ) ?  $new_instance['share-stumbleupon']  : '';
        return $instance;
    }
}


/* ========= numismatico_recent_icos_with_thumbnail ===================================== */
class numismatico_recent_icos_with_thumbnail extends WP_Widget {
    /**
     * Register widget with WordPress.
     */
    function __construct() {
        parent::__construct('numismatico_recent_icos_with_thumbnail', esc_attr__('MT - Recent ICO\'s with thumbnails', 'modeltheme'),array( 'description' => esc_attr__( 'MT - Recent ICO\'s with thumbnails', 'modeltheme' ), ) );
    }
    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget( $args, $instance ) {
        $recent_posts_title = $instance[ 'recent_posts_title' ];
        $recent_posts_number = $instance[ 'recent_posts_number' ];
        echo  $args['before_widget'];
        $args_recenposts = array(
                'posts_per_page'   => $recent_posts_number,
                'orderby'          => 'post_date',
                'order'            => 'DESC',
                'post_type'        => 'mt_listing',
                'post_status'      => 'publish' 
                );
        $recentposts = get_posts($args_recenposts);
        $myContent  = "";
        $myContent .= '<h3 class="widget-title">'.$recent_posts_title.'</h3>';
        $myContent .= '<ul>';
        foreach ($recentposts as $post) {
            $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ));
            $mt_listing_end_date_pick = get_post_meta( $post->ID, 'mt_listing_end_date_pick', true );
            $mt_select_font = get_post_meta( $post->ID, 'mt_select_font', true );
            $mt_font_cryptocoins_icons = get_post_meta( $post->ID, 'mt_font_cryptocoins_icons', true );
            $mt_font_awesome_icons = get_post_meta( $post->ID, 'mt_font_awesome_icons', true );
            $mt_font_simple_line = get_post_meta( $post->ID, 'mt_font_simple_line_icons', true );
            //Thumbnail
            $post_img = '';
            if ($thumbnail_src) {
                $post_img = '<img class="blog_post_image" src="'. esc_url($thumbnail_src[0]) . '" alt="'.$post->post_title.'" />';
            }
            // COMPARE DATES
	          $mt_listing_end_date_pick_new_format = date('Y-m-d H:i:s', strtotime($mt_listing_end_date_pick));
	          $todaydate = date("Y-m-d H:i:s");
	          if($todaydate > $mt_listing_end_date_pick_new_format){
	            $end_label = esc_html__('Ended: ' ,'mtlisitings') . date('M m, Y', strtotime($mt_listing_end_date_pick));
	          }else{
	            $end_label = esc_html__('End: ' ,'mtlisitings') .  date('M m, Y', strtotime($mt_listing_end_date_pick));
	          }
            $myContent .= '<li class="row">';
                $myContent .= '<div class="vc_col-xs-3 vc_col-md-3 post-thumbnail">';
                    $myContent .= '<a class="relative" href="'. get_permalink($post->ID) .'">';
                        $myContent .= '<div class="ico-icon relative">';
                            if (!empty($post_img)) {
                              $myContent .= $post_img;
                            } else {
                              $myContent .= '<div class="featured-icon relative">';
                                if (isset($mt_select_font) && $mt_select_font == 'cryptocoins_icons') {
                                  if($mt_font_cryptocoins_icons) {
                                    $myContent .= '<i class="'.esc_attr($mt_font_cryptocoins_icons).'"></i>';
                                  }
                                } elseif (isset($mt_select_font) && $mt_select_font == 'font_awesome_icons') {
                                  if($mt_font_awesome_icons) {
                                    $myContent .= '<i class="'.esc_attr($mt_font_awesome_icons).'"></i>';
                                  }
                                } elseif (isset($mt_select_font) && $mt_select_font == 'simple_line_icons') {
                                  if($mt_font_simple_line) {
                                    $myContent .= '<i class="'.esc_attr($mt_font_simple_line).'"></i>';
                                  }
                                }
                              $myContent .= '</div>';
                            }
                        $myContent .= '</div>';
                    $myContent .= '</a>';
                $myContent .= '</div>';
                $myContent .= '<div class="vc_col-xs-9 vc_col-md-9 post-details">';
                    $myContent .= '<a href="'. get_permalink($post->ID) .'">'. $post->post_title.'</a>';
                    $myContent .= '<p class="post-date">'.$end_label.'</p>';
                $myContent .= '</div>';
            $myContent .= '</li>';
        }
        $myContent .= '</ul>';
        echo  $myContent;
        echo  $args['after_widget'];
    }
    /**
     * Back-end widget form.
     *
     * @see WP_Widget::form()
     *
     * @param array $instance Previously saved values from database.
     */
    public function form( $instance ) {
        
        # Widget Title
        if ( isset( $instance[ 'recent_posts_title' ] ) ) {
            $recent_posts_title = $instance[ 'recent_posts_title' ];
        } else {
            $recent_posts_title = esc_attr__( 'Recent ICOs', 'modeltheme' );
        }
        # Number of posts
        if ( isset( $instance[ 'recent_posts_number' ] ) ) {
            $recent_posts_number = $instance[ 'recent_posts_number' ];
        } else {
            $recent_posts_number = '3';
        }
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'recent_posts_title' )); ?>"><?php esc_attr_e( 'Widget Title:','modeltheme' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'recent_posts_title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'recent_posts_title' )); ?>" type="text" value="<?php echo esc_attr( $recent_posts_title ); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'recent_posts_number' )); ?>"><?php esc_attr_e( 'Number of ICOs:','modeltheme' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'recent_posts_number' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'recent_posts_number' )); ?>" type="text" value="<?php echo esc_attr( $recent_posts_number ); ?>">
        </p>
        <?php 
    }
    /**
     * Sanitize widget form values as they are saved.
     *
     * @see WP_Widget::update()
     *
     * @param array $new_instance Values just sent to be saved.
     * @param array $old_instance Previously saved values from database.
     *
     * @return array Updated safe values to be saved.
     */
    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['recent_posts_title'] = ( ! empty( $new_instance['recent_posts_title'] ) ) ?  $new_instance['recent_posts_title']  : '';
        $instance['recent_posts_number'] = ( ! empty( $new_instance['recent_posts_number'] ) ) ? strip_tags( $new_instance['recent_posts_number'] ) : '';
        return $instance;
    }
}


// Register Widgets
function numismatico_register_widgets() {
    register_widget( 'numismatico_address_social_icons' );
    register_widget( 'numismatico_social_share' );
    register_widget( 'numismatico_recent_entries_with_thumbnail' );
    register_widget( 'numismatico_recent_icos_with_thumbnail' );
    register_widget( 'numismatico_post_thumbnails_slider' );
}
add_action( 'widgets_init', 'numismatico_register_widgets' );