<?php
/**
* Plugin Name: ModelTheme Framework
* Plugin URI: http://modeltheme.com/
* Description: ModelTheme Framework required by MODELTHEME Theme.
* Version: 1.7
* Author: ModelTheme
* Author http://modeltheme.com/
* Text Domain: smartowl
*/
$plugin_dir = plugin_dir_path( __FILE__ );
/**
||-> Function: Dynamic Featured Image for 'portfolio' CPT only
*/
function modeltheme_allowed_post_types() {
    return array('portfolio', 'mt_house'); //show DFI only in post
}
add_filter('dfi_post_types', 'modeltheme_allowed_post_types');

/**
||-> Function: require_once() plugin necessary parts
*/
require_once('inc/post-types/post-types.php'); // POST TYPES
require_once('inc/shortcodes/shortcodes.php'); // SHORTCODES
require_once('inc/widgets/widgets-theme.php'); // WIDGETS
require_once('inc/metaboxes/metaboxes.php'); // METABOXES
require_once('inc/demo-importer-v2/wbc907-plugin-example.php');
if ( ! class_exists( 'Dynamic_Featured_Image' ) ){
    require_once('inc/dynamic-featured-image/dynamic-featured-image.php'); // DYNAMIC FEATURED IMAGE
}
require_once('inc/sb-google-maps-vc-addon/sb-google-maps-vc-addon.php'); // GMAPS
require_once('inc/custom-functions.php'); // CUSTOM FUNCTIONS


/**
||-> Function: LOAD PLUGIN TEXTDOMAIN
*/
function modeltheme_load_textdomain(){
    $domain = 'modeltheme';
    $locale = apply_filters( 'plugin_locale', get_locale(), $domain );
    load_textdomain( $domain, trailingslashit( WP_LANG_DIR ) . $domain . '/' . $domain . '-' . $locale . '.mo' );
    load_plugin_textdomain( $domain, FALSE, basename( plugin_dir_path( dirname( __FILE__ ) ) ) . '/languages/' );
}
add_action( 'plugins_loaded', 'modeltheme_load_textdomain' );
/**
||-> Function: modeltheme_framework()
*/
function modeltheme_framework() {
    // CSS
    wp_register_style( 'style-shortcodes-inc',  plugin_dir_url( __FILE__ ) . 'inc/shortcodes/shortcodes.css' );
    wp_enqueue_style( 'style-shortcodes-inc' );
    wp_register_style( 'style-select2',  plugin_dir_url( __FILE__ ) . 'css/select2.min.css' );
    wp_enqueue_style( 'style-select2' );
    wp_register_style( 'style-animations',  plugin_dir_url( __FILE__ ) . 'css/animations.css' );
    wp_enqueue_style( 'style-animations' );
    
    // SCRIPTS
    wp_enqueue_script( 'classie', plugin_dir_url( __FILE__ ) . 'js/classie.js', array('jquery'), '1.0.0', true );
    wp_enqueue_script( 'js-mt-plugins', plugin_dir_url( __FILE__ ) . 'js/mt-plugins.js', array(), '1.0.0', true );
    wp_enqueue_script( 'select2', plugin_dir_url( __FILE__ ) . 'js/select2.min.js', array(), '1.0.0', true );
    wp_enqueue_script( 'js-modeltheme-custom', plugin_dir_url( __FILE__ ) . 'js/modeltheme-custom.js', array('jquery'), '1.0.0', true );
    wp_enqueue_script( 'magnific-popup', plugin_dir_url( __FILE__ ) . 'js/mt-video/jquery.magnific-popup.js', array(), '1.0.0', true );
    wp_enqueue_script( 'js-modeltheme-mt-coundown-version2', plugin_dir_url( __FILE__ ) . 'js/mt-coundown-version2/flipclock.js', array('jquery'), '1.0.0', true );
    
}
add_action( 'wp_enqueue_scripts', 'modeltheme_framework' );
/**
||-> Function: modeltheme_enqueue_admin_scripts()
*/
function modeltheme_enqueue_admin_scripts( $hook ) {
    // JS
    wp_enqueue_script( 'js-modeltheme-admin-custom', plugin_dir_url( __FILE__ ) . 'js/modeltheme-custom-admin.js', array(), '1.0.0', true );
    // CSS
    wp_register_style( 'css-modeltheme-custom',  plugin_dir_url( __FILE__ ) . 'css/modeltheme-custom.css' );
    wp_enqueue_style( 'css-modeltheme-custom' );
    wp_register_style( 'css-fontawesome-icons',  plugin_dir_url( __FILE__ ) . 'css/font-awesome.min.css' );
    wp_enqueue_style( 'css-fontawesome-icons' );
    wp_register_style( 'css-simple-line-icons',  plugin_dir_url( __FILE__ ) . 'css/simple-line-icons.css' );
    wp_enqueue_style( 'css-simple-line-icons' );
    wp_register_style( 'cryptocoins-icons',  plugin_dir_url( __FILE__ ) . 'fonts/cryptocoins.css' );
    wp_enqueue_style( 'cryptocoins-icons' );
}
add_action('admin_enqueue_scripts', 'modeltheme_enqueue_admin_scripts');


add_image_size( 'mt_1250x700', 1250, 700, true );
add_image_size( 'mt_320x480', 320, 480, true );
add_image_size( 'mt_900x550', 900, 550, true );


/**
||-> Function: modeltheme_cmb_initialize_cmb_meta_boxes
*/
function modeltheme_cmb_initialize_cmb_meta_boxes() {
    if ( ! class_exists( 'cmb_Meta_Box' ) )
        require_once ('init.php');
}
add_action( 'init', 'modeltheme_cmb_initialize_cmb_meta_boxes', 9999 );


/**
||-> Function: modeltheme_cmb_initialize_cmb_meta_boxes
*/
function modeltheme_excerpt_limit($string, $word_limit) {
    $words = explode(' ', $string, ($word_limit + 1));
    if(count($words) > $word_limit) {
        array_pop($words);
    }
    return implode(' ', $words);
}


if ( class_exists( 'WooCommerce' ) ) {
    function wc_custom_lost_password_form( $atts ) {
        return wc_get_template( 'myaccount/form-lost-password.php', array( 'form' => 'lost_password' ) );
    }
    add_shortcode( 'lost_password_form', 'wc_custom_lost_password_form' );
}


function numismatico_sharer(){
    $html = '';
    $html .= '<span class="article-social">
                <ul class="social-sharer">
                    <li class="facebook">
                        <a target="_blank" data-toggle="tooltip" title="'.esc_html__('Share on Facebook','numismatico').'" data-placement="top" href="http://www.facebook.com/share.php?u='.get_permalink().'&amp;title='.get_the_title().'"><i class="fa fa-facebook"></i></a>
                    </li>
                    <li class="twitter">
                        <a target="_blank" data-toggle="tooltip" title="'.esc_html__('Share on Twitter','numismatico').'" data-placement="top" href="http://twitter.com/home?status='.get_the_title().'+'.get_permalink().'"><i class="fa fa-twitter"></i></a>
                    </li>
                    <li class="linkedin">
                        <a target="_blank" data-toggle="tooltip" title="'.esc_html__('Share on LinkedIn','numismatico').'" data-placement="top" href="http://www.linkedin.com/shareArticle?mini=true&amp;url='.get_permalink().'&amp;title='.get_the_title().'&amp;source='.get_permalink().'"><i class="fa fa-linkedin"></i></a>
                    </li>
                    <li class="google-plus">
                        <a target="_blank" data-toggle="tooltip" title="'.esc_html__('Share on Google','numismatico').'" data-placement="top" href="https://plus.google.com/share?url='.get_permalink().'"><i class="fa fa-google"></i></a>
                    </li>
                    <li class="pinterest">
                        <a target="_blank" data-toggle="tooltip" title="'.esc_html__('Pin on Pinterest','numismatico').'" data-placement="top" href="http://pinterest.com/pin/create/bookmarklet/?media='.get_permalink().'&url='.get_permalink().'&is_video=false&description='.get_permalink().'"><i class="fa fa-pinterest-p"></i></a>
                    </li>
                    <li class="reddit">
                        <a target="_blank" data-toggle="tooltip" title="'.esc_html__('Share on Reddit','numismatico').'" data-placement="top" href="http://www.reddit.com/submit?url='.get_permalink().'&amp;title='.get_the_title().'"><i class="fa fa-reddit-alien"></i></a>
                    </li>
                    <li class="tumblr">
                        <a target="_blank" data-toggle="tooltip" title="'.esc_html__('Share on Tumblr','numismatico').'" data-placement="top" href="http://www.tumblr.com/share?v=3&amp;u='.get_permalink().'&amp;t='.get_the_title().'"><i class="fa fa-tumblr"></i></a>
                    </li>
                </ul>
            </span>';
    return $html;
}