<?php 
/**
||-> Shortcode: BlogPos01
*/
function modeltheme_shortcode_icodrops_slider($params, $content) {
    extract( shortcode_atts( 
        array(
            'animation'           =>'',
            'visible_items_posts' => '',
            'category'            => '',
            'number'              =>'',
        ), $params ) );
    $html = '';


    if ($category == '') {
      $args_blogposts = array(
              'posts_per_page'   => $number,
              'order'            => 'DESC',
              'orderby'          => 'post_date',
              'post_type'        => 'mt_listing',
              'post_status'      => 'publish' 
              ); 
    }else{
      $args_blogposts = array(
              'posts_per_page'   => $number,
              'order'            => 'DESC',
              'orderby'          => 'post_date',
              'post_type'        => 'mt_listing',
              'tax_query' => array(
                  array(
                      'taxonomy' => 'mt-listing-category',
                      'field' => 'slug',
                      'terms' => $category
                  )
              ),
              'post_status'      => 'publish' 
              ); 
    }




      $html .= '<div class="row">';
      $html .= '<div class="icondrops-slider-shortcode wow '.$animation.' icodrops_slider_container_shortcode-'.$visible_items_posts.' owl-carousel owl-theme">';
    

    $blogposts = get_posts($args_blogposts);
    foreach ($blogposts as $blogpost) {
        #thumbnail
        $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( $blogpost->ID ));
        $mt_listing_end_date_pick = get_post_meta( $blogpost->ID, 'mt_listing_end_date_pick', true );
        $mt_select_font = get_post_meta( $blogpost->ID, 'mt_select_font', true );
        $mt_font_cryptocoins_icons = get_post_meta( $blogpost->ID, 'mt_font_cryptocoins_icons', true );
        $mt_font_awesome_icons = get_post_meta( $blogpost->ID, 'mt_font_awesome_icons', true );
        $mt_font_simple_line = get_post_meta( $blogpost->ID, 'mt_font_simple_line_icons', true );
        $mt_listing_sponsored_status = get_post_meta( $blogpost->ID, 'mt_listing_sponsored_status', true );
        $mt_icodrops_slider_bg = get_post_meta( $blogpost->ID, 'mt_icodrops_slider_bg', true );
        
        $icon_feature = '';
        ?>
          
        <?php if (isset($mt_select_font) && $mt_select_font == 'cryptocoins_icons') { ?>
          <?php if($mt_font_cryptocoins_icons) { ?>
            <?php $icon_feature = '<i class="'.esc_attr($mt_font_cryptocoins_icons).'"></i>'; ?>
          <?php } ?>
        <?php } elseif (isset($mt_select_font) && $mt_select_font == 'font_awesome_icons') { ?>
          <?php if($mt_font_awesome_icons) { ?>
            <?php $icon_feature = '<i class="'.esc_attr($mt_font_awesome_icons).'"></i>'; ?>
          <?php } ?>
        <?php } elseif (isset($mt_select_font) && $mt_select_font == 'simple_line_icons') { ?>
          <?php if($mt_font_simple_line) { ?>
            <?php $icon_feature = '<i class="'.esc_attr($mt_font_simple_line).'"></i>'; ?>
          <?php } ?>
        <?php } ?>
        <?php if ($thumbnail_src) {
            $post_img = '<img class="blog_post_image" src="'. esc_url($thumbnail_src[0]) . '" alt="'.$blogpost->post_title.'" />';
        }else{
            $post_img = $icon_feature;
        }
        
        // COMPARE DATES
    $mt_listing_end_date_pick_new_format = date('Y-m-d H:i:s', strtotime($mt_listing_end_date_pick));
    $todaydate = date("Y-m-d H:i:s");
    $dot = '';
    if($todaydate > $mt_listing_end_date_pick_new_format){
      $end_label = esc_html__('Ended: ' ,'mtlisitings') . date('M m, Y', strtotime($mt_listing_end_date_pick));
    }else{
      $end_label = date('M m, Y', strtotime($mt_listing_end_date_pick));
      $dot = '<span class="icodrops-slider-dot">● </span>';
    }
  
        $html.='<div class="col-md-12 post '.esc_attr($mt_listing_sponsored_status).'">
                  <div class="blog_custom_listings">
                    <div class="row">
                      <div class="col-md-12">
                        <div class="icodrops-slider-content-top" style="background-image: url('.esc_attr($mt_icodrops_slider_bg).'); background-size: cover;">
                          <h4 class="post-name-listings"><a href="'.get_permalink($blogpost->ID).'">'.$blogpost->post_title.'</a></h4>
                          <a class="icodrops-slider-content-logo" href="'.get_permalink($blogpost->ID).'">'.$post_img.'</a>
                        </div>
                      </div>
                      <div class="col-md-12">                                
                          <div class="ico-drops-slider-date">
                            '.$dot.' '.esc_html($end_label).'
                          </div>
                      </div>
                    </div>
                  </div>
                </div>';
      }
    $html .= '</div>';
    $html .= '</div>';   
    return $html;
}
add_shortcode('icodrops-slider', 'modeltheme_shortcode_icodrops_slider');
/**
||-> Map Shortcode in Visual Composer with: vc_map();
*/
if ( is_plugin_active( 'js_composer/js_composer.php' ) ) {
  require_once __DIR__ . '/../vc-shortcodes.inc.arrays.php';
  global $wpdb;
  $myrows=$wpdb->get_results("SELECT name FROM {$wpdb->prefix}terms 
  WHERE term_id IN (SELECT term_id FROM {$wpdb->prefix}term_taxonomy where taxonomy = 'mt-listing-category');" );

  $taxonomy = array();
  $taxonomy = array_merge($taxonomy, array("From all Categories"=>""));

  foreach($myrows as $row) {
    $taxonomy[] = $row->name;
  }

  vc_map( array(
     "name" => esc_attr__("MT - Ico Drops Slider", 'mtlisitings'),
     "base" => "icodrops-slider",
     "category" => esc_attr__('MT: ModelTheme', 'mtlisitings'),
     "icon" => "smartowl_shortcode",
     "params" => array(
        array(
          "group" => "Options",
          "type" => "textfield",
          "holder" => "div",
          "class" => "",
          "heading" => esc_attr__( "Number of posts", 'mtlisitings' ),
          "param_name" => "number",
          "value" => "",
          "description" => esc_attr__( "Enter number of blog post to show.", 'mtlisitings' )
        ),
        array(
          "group" => "Options",
          "type" => "dropdown",
          "heading" => esc_attr__("Visible Post per slide", 'modeltheme'),
          "param_name" => "visible_items_posts",
          "std" => '',
          "holder" => "div",
          "class" => "",
          "description" => "",
          "value" => array(
            '1'   => '1',
            '2'   => '2',
            '3'   => '3',
            '4'   => '4',
            '5'   => '5'
            )
        ),
        array(
           "type" => "dropdown",
           "group" => "Options",
           "holder" => "div",
           "class" => "",
           "heading" => esc_attr__("Select Category", 'mtlisitings'),
           "param_name" => "category",
           "description" => esc_attr__("Please select category", 'mtlisitings'),
           "std" => esc_attr__('Default value', 'mtlisitings'),
           "value" => $taxonomy
        ),
        array(
          "group" => "Animation",
          "type" => "dropdown",
          "heading" => esc_attr__("Animation", 'mtlisitings'),
          "param_name" => "animation",
          "std" => 'fadeInLeft',
          "holder" => "div",
          "class" => "",
          "description" => "",
          "value" => $animations_list
        )
      )
  ));
}