<?php 
/**
||-> Shortcode: BlogPos01
*/
function modeltheme_shortcode_icodrops($params, $content) {
    extract( shortcode_atts( 
        array(
            'animation'           =>'',
            'category'            => '',
            'number'              =>'',
        ), $params ) );
    $html = '';
    $html .= '<div class="icondrops-shortcode wow '.$animation.'">';
    $html .= '<div class="row">';
    $html .= '<div class="col-md-12">
    			<div class="ico-drops-category">
    				<h3>'.esc_attr($category).'</h3>
    			</div>
    		</div>';

    $args_blogposts = array(
            'posts_per_page'   => $number,
            'order'            => 'DESC',
            'post_type'        => 'mt_listing',
            'tax_query' => array(
                array(
                    'taxonomy' => 'mt-listing-category',
                    'field' => 'slug',
                    'terms' => $category
                )
            ),
            'post_status'      => 'publish' 
            ); 
    
    $blogposts = get_posts($args_blogposts);
    foreach ($blogposts as $blogpost) {
        #thumbnail
        $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( $blogpost->ID ));
        $mt_listing_category = get_post_meta( $blogpost->ID, 'mt_listing_category', true ); 
        $mt_listing_received = get_post_meta( $blogpost->ID, 'mt_listing_received', true );
        $mt_listing_fundraising_goal = get_post_meta( $blogpost->ID, 'mt_listing_fundraising_goal', true );
        $mt_listing_received_percentage = get_post_meta( $blogpost->ID, 'mt_listing_received_percentage', true );
        $mt_listing_interest = get_post_meta( $blogpost->ID, 'mt_listing_interest', true );
        $mt_listing_end_date_pick = get_post_meta( $blogpost->ID, 'mt_listing_end_date_pick', true );
        $mt_select_font = get_post_meta( $blogpost->ID, 'mt_select_font', true );
        $mt_font_cryptocoins_icons = get_post_meta( $blogpost->ID, 'mt_font_cryptocoins_icons', true );
        $mt_font_awesome_icons = get_post_meta( $blogpost->ID, 'mt_font_awesome_icons', true );
        $mt_font_simple_line = get_post_meta( $blogpost->ID, 'mt_font_simple_line_icons', true );
        $mt_listing_sponsored_status = get_post_meta( $blogpost->ID, 'mt_listing_sponsored_status', true );
        
        $icon_feature = '';
        ?>
          
        <?php if (isset($mt_select_font) && $mt_select_font == 'cryptocoins_icons') { ?>
          <?php if($mt_font_cryptocoins_icons) { ?>
            <?php $icon_feature = '<i class="'.esc_attr($mt_font_cryptocoins_icons).'"></i>'; ?>
          <?php } ?>
        <?php } elseif (isset($mt_select_font) && $mt_select_font == 'font_awesome_icons') { ?>
          <?php if($mt_font_awesome_icons) { ?>
            <?php $icon_feature = '<i class="'.esc_attr($mt_font_awesome_icons).'"></i>'; ?>
          <?php } ?>
        <?php } elseif (isset($mt_select_font) && $mt_select_font == 'simple_line_icons') { ?>
          <?php if($mt_font_simple_line) { ?>
            <?php $icon_feature = '<i class="'.esc_attr($mt_font_simple_line).'"></i>'; ?>
          <?php } ?>
        <?php } ?>
        <?php if ($thumbnail_src) {
            $post_img = '<img class="blog_post_image" src="'. esc_url($thumbnail_src[0]) . '" alt="'.$blogpost->post_title.'" />';
        }else{
            $post_img = $icon_feature;
        }
        
        $content_post   = get_post($blogpost->ID);
        $content        = $content_post->post_content;
        $content        = apply_filters('the_content', $content);
        $content        = str_replace(']]>', ']]&gt;', $content);
        $comments_count = wp_count_comments($blogpost->ID);
        if($comments_count->approved >= 1) {
            $comments = __('Comments','mtlisitings') .'<a href="'.get_comments_link($blogpost->ID).'">'. $comments_count->approved.'</a>';
        } else {
            $comments = __('No comments','mtlisitings');
        }
        $term_list = wp_get_post_terms($blogpost->ID, 'mt-listing-category2');
        $sticky_class = '';
        if ( is_sticky($blogpost->ID) ) {
            $sticky_class = 'is-sticky';
        }
        $mt_listing_received_without_comma = str_replace( ',', '', $mt_listing_received );
        $mt_listing_goal_money_without_comma = str_replace( ',', '', $mt_listing_fundraising_goal );
        $mt_listing_received_without_dollar = str_replace( '$', '', $mt_listing_received_without_comma );
        $mt_listing_goal_without_dollar = str_replace( '$', '', $mt_listing_goal_money_without_comma );
        $percentage = ( $mt_listing_received_without_dollar * 100 ) / $mt_listing_goal_without_dollar; 
        $mt_select_rating_star_recent = get_post_meta( $blogpost->ID, 'mt_select_rating_star', true );
        $my_excerpt = get_the_excerpt( $blogpost->ID); 

        // TAXONOMY PHOTO/ICON
        $taxonomy_image_id = get_term_meta ( $term_list[0]->term_id, 'category-image-id', true );
        $tax_img = '';
        if (wp_get_attachment_image ( $taxonomy_image_id, 'thumbnail' )) {
        	$tax_img = wp_get_attachment_image ( $taxonomy_image_id, 'thumbnail' );
        }

        if(!empty($mt_select_rating_star_recent)) {
            $percentage_rating_recent = $mt_select_rating_star_recent;
        } else {
            $percentage_rating_recent = '0%';
        }     

        // COMPARE DATES
		$mt_listing_end_date_pick_new_format = date('Y-m-d H:i:s', strtotime($mt_listing_end_date_pick));
		$todaydate = date("Y-m-d H:i:s");

		if($todaydate > $mt_listing_end_date_pick_new_format){
			$end_label = esc_html__('Ended: ' ,'mtlisitings') . date('M m, Y', strtotime($mt_listing_end_date_pick));
		}else{
			$end_label = date('M m, Y', strtotime($mt_listing_end_date_pick));
		}


        $now = time(); // or your date as well
        $your_date = strtotime($mt_listing_end_date_pick);
        $datediff = $now - $your_date;
        $date_dif = abs(round($datediff / (60 * 60 * 24)));       
        $html.='<div class="col-md-12 post '.esc_attr($sticky_class).' '.esc_attr($mt_listing_sponsored_status).'">
                  <div class="blog_custom_listings">
                    <div class="row">
                      <div class="col-md-3">
                        <a class="relative" href="'.get_permalink($blogpost->ID).'">'.$post_img.'</a>
                      </div>
                      <div class="col-md-9">
                        <h4 class="post-name-listings"><a href="'.get_permalink($blogpost->ID).'">'.$blogpost->post_title.'</a></h4>
                        <a href="'.esc_url(get_term_link($term_list[0]->name, 'mt-listing-category2')).'">
                          <h6 class="mt_listing_category_recent">'. $tax_img .esc_attr($term_list[0]->name).'</h6>
                        </a>
                      </div>
                    </div>
                    <div class="listings_details">                                    
						<p class="numismatico-details-content">'.mtlisitings_excerpt_limit($my_excerpt, 8).' (...)</p>
                      	<h6 class="mt_listing_interest_end_date">
                          <span class="ico-drops-interest">'.esc_attr($mt_listing_interest).'</span>
                          <span class="ico-drops-date">'.esc_attr($end_label).'</span>
                      	</h6>
                    </div>
                  </div>
                </div>';
      }

    $html .= '</div>';
    $html .= '</div>';   
    return $html;
}
add_shortcode('icodrops', 'modeltheme_shortcode_icodrops');
/**
||-> Map Shortcode in Visual Composer with: vc_map();
*/
if ( is_plugin_active( 'js_composer/js_composer.php' ) ) {
  require_once __DIR__ . '/../vc-shortcodes.inc.arrays.php';
  global $wpdb;
  $myrows=$wpdb->get_results("SELECT name FROM {$wpdb->prefix}terms 
  WHERE term_id IN (SELECT term_id FROM {$wpdb->prefix}term_taxonomy where taxonomy = 'mt-listing-category');" );
  $taxonomy = array();
  foreach($myrows as $row) {
    $taxonomy[] = $row->name;
  }
  vc_map( array(
     "name" => esc_attr__("MT - Ico Drops", 'mtlisitings'),
     "base" => "icodrops",
     "category" => esc_attr__('MT: ModelTheme', 'mtlisitings'),
     "icon" => "smartowl_shortcode",
     "params" => array(
        array(
          "group" => "Options",
          "type" => "textfield",
          "holder" => "div",
          "class" => "",
          "heading" => esc_attr__( "Number of posts", 'mtlisitings' ),
          "param_name" => "number",
          "value" => "",
          "description" => esc_attr__( "Enter number of blog post to show.", 'mtlisitings' )
        ),
        array(
           "type" => "dropdown",
           "group" => "Options",
           "holder" => "div",
           "class" => "",
           "heading" => esc_attr__("Select Category", 'mtlisitings'),
           "param_name" => "category",
           "description" => esc_attr__("Please select category", 'mtlisitings'),
           "std" => esc_attr__('Default value', 'mtlisitings'),
           "value" => $taxonomy
        ),
        array(
          "group" => "Animation",
          "type" => "dropdown",
          "heading" => esc_attr__("Animation", 'mtlisitings'),
          "param_name" => "animation",
          "std" => 'fadeInLeft',
          "holder" => "div",
          "class" => "",
          "description" => "",
          "value" => $animations_list
        )
      )
  ));
}
?>