<?php 
/**
||-> Shortcode: BlogPos01
*/
function modeltheme_shortcode_icofilters($params, $content) {
    extract( shortcode_atts( 
        array(
            'animation'                                =>'',
            'number'                                   =>'',
            'items_per_row'                            =>'',
            'mtlistings_style_variant'                 =>'',
            'filtersidebar'                            =>'',
            'searchfilter'                             =>'',
            'title_color'                              =>'',
            'desc_color'                               =>'',
            'title_bg'                                 =>'',
            'btn_background_color_normal'              =>'',
            'btn_background_color_normal_hover'        =>'',
            'extra_class'                              =>''
        ), $params ) );


    $id = 'mt_ico_filters_'.uniqid();

    $html = '';
    $html .= '<style>';
      // normal state
      if (isset($btn_background_color_normal)) {
        $html .= '#'.$id.' .ico-cat-parent-subtitle a {
                    border: 2px solid '.$btn_background_color_normal.';
                }';
      }
      // hover state
      if (isset($btn_background_color_normal_hover)) {
        $html .= '#'.$id .'.ico-cat-parent-subtitle a:hover {
                    background: '.$btn_background_color_normal_hover.' !important;
                    border: 2px solid '.$btn_background_color_normal_hover.' !important;
                }';
      }
    $html .=' </style>';


    // STYLE VARIANT
    $html .= '<div id="'.esc_attr($id).'" class="iconfilter-shortcode wow '.$animation.' '.$mtlistings_style_variant.' '.$extra_class.'">';
      $html .= '<div class="row">';
        $html .= '<div class="numismatico-main-content">';
          $html .= '<section class="numismatico-gallery">';

            if($filtersidebar == 'sidebar_on') {

              $html .= '<div class="col-md-12 iconfilter-search">';
                $html .= '<div class="numismatico-filter" id="numismatico_stickit">';
                  $html .= '<div class="row">';
                    $html .= '<div class="numismatico-filter-inner-group">';

                      $html .= '<div class="col-md-8 numismatico-tab-filter-wrapper">';
                        $html .= '<div class="numismatico-tab-filter">';
                          $html .= '<ul class="numismatico-filters">';

                            $listing_tax_types = get_terms( array( 
                              'taxonomy' => 'mt-listing-category',
                              'parent'   => 0
                            ));

                            if ( !empty($listing_tax_types) ){
                              foreach( $listing_tax_types as $tax ) {
                                $html .= '<li class="filter" data-filter=".'.esc_attr($tax->slug).'">';
                                  $html .= '<a href="#'.esc_attr($tax->slug).'" data-type="'.esc_attr($tax->slug).'">';
                                    $html .= esc_attr($tax->name).' ('.esc_attr($tax->count).')';
                                  $html .= '</a>';
                                $html .= '</li>';
                              }
                            }
                          $html .= '</ul>';
                        $html .= '</div>';
                      $html .= '</div>';

                        $html .= '<div class="col-md-4">';
                            
                          if($searchfilter == 'search_on') {
                            $html .= '<div class="numismatico-filter-block">';
                              $html .= '<div class="numismatico-filter-content">';

                                if ($mtlistings_style_variant == 'mtlistings-ico-style-v1') {
                                      $html .= '<form method="get" id="searchform" action="'.esc_url( home_url( '/' ) ).'">
                                            <input type="text" class="field" name="s" id="s" placeholder="'.esc_attr__( 'Type keyword...', 'mtlisitings' ).'" />
                                            <input type="hidden" name="post_type" value="mt_listing">
                                            <button type="submit" class="submit" name="submit" id="searchsubmit"><i class="fa fa-search" aria-hidden="true"></i></button>
                                          </form>';
                                    }elseif ($mtlistings_style_variant == 'mtlistings-ico-style-v2') {
                                      $html .= '<form method="get" id="searchform" action="'.esc_url( home_url( '/' ) ).'">
                                            <input type="text" class="field" name="s" id="s" placeholder="'.esc_attr__( 'Type keyword...', 'mtlisitings' ).'" />
                                            <input type="hidden" name="post_type" value="mt_listing">
                                            <button type="submit" class="submit" name="submit" id="searchsubmit">'.esc_html__( 'Search', 'mtlisitings' ).'</button>
                                          </form>';
                                    }
                                
                              $html .= '</div>';
                            $html .= '</div>';
                          }
                        $html .= '</div>';
                    $html .= '</div>';
                  $html .= '</div>';
                $html .= '</div>';
              $html .= '</div>';
            }



          $html .= '<div class="col-md-12 iconfilter-listing">';

            // TAXONOMY LISTS
            $mt_listing_cat_args = array('taxonomy' => 'mt-listing-category', 'type' => 'mt_listing', 'orderby' => 'name', 'order' => 'ASC', 'parent' => 0);
            $mt_listing_cat = get_categories($mt_listing_cat_args);
            $cat_position = 0;
            foreach($mt_listing_cat as $mt_listing_single_cat) { 
              // TAXONOMY NAME/LINK
              $html .= '<div id="'.$mt_listing_single_cat->slug.'" class="ico-cat-parent big-parent">';
                  
                $html .= '<div class="ico-cat-parent-title" style="background: '.$title_bg.'">
                            <h3 style="color: '.$title_color.';">'.$mt_listing_single_cat->cat_name.' ('.$mt_listing_single_cat->category_count.')</h3>
                            <p style="color: '.$desc_color.';">'.$mt_listing_single_cat->category_description.'</p>
                          </div>';

                if ($mtlistings_style_variant == 'mtlistings-ico-style-v2') {
                  $html.='<div class="ico-cat-single-list-row row">';
                }elseif ($mtlistings_style_variant == 'mtlistings-ico-style-v1') {
                  $html.='<div class="ico-cat-single-list-row">';
                }

                // TAXONOMY POSTS by Current TAXONOMY
                $args_blogposts = array(
                  'posts_per_page'   => $number,
                  'order'            => 'DESC',
                  'post_type'        => 'mt_listing',
                  'tax_query' => array(
                    array(
                      'taxonomy' => 'mt-listing-category',
                      'field' => 'id',
                      'terms' => $mt_listing_single_cat->term_id
                    )
                  ),
                  'post_status'      => 'publish' 
                ); 
                $blogposts = get_posts($args_blogposts);

                // START FOREACH
                $i = 1;
                foreach ($blogposts as $blogpost) {
                  #thumbnail
                  $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( $blogpost->ID ));
                  $mt_listing_category = get_post_meta( $blogpost->ID, 'mt_listing_category', true ); 
                  $mt_listing_received = get_post_meta( $blogpost->ID, 'mt_listing_received', true );
                  $mt_listing_fundraising_goal = get_post_meta( $blogpost->ID, 'mt_listing_fundraising_goal', true );
                  $mt_listing_received_percentage = get_post_meta( $blogpost->ID, 'mt_listing_received_percentage', true );
                  $mt_listing_interest = get_post_meta( $blogpost->ID, 'mt_listing_interest', true );
                  $mt_listing_end_date_pick = get_post_meta( $blogpost->ID, 'mt_listing_end_date_pick', true );
                  $mt_select_font = get_post_meta( $blogpost->ID, 'mt_select_font', true );
                  $mt_font_cryptocoins_icons = get_post_meta( $blogpost->ID, 'mt_font_cryptocoins_icons', true );
                  $mt_font_awesome_icons = get_post_meta( $blogpost->ID, 'mt_font_awesome_icons', true );
                  $mt_font_simple_line = get_post_meta( $blogpost->ID, 'mt_font_simple_line_icons', true );
                  $mt_listing_sponsored_status = get_post_meta( $blogpost->ID, 'mt_listing_sponsored_status', true );
                  $mt_select_rating_star = get_post_meta( $blogpost->ID, 'mt_select_rating_star', true );
                  $my_excerpt = get_the_excerpt( $blogpost->ID); 
                  $icon_feature = '';
                  ?>
                  <?php if (isset($mt_select_font) && $mt_select_font == 'cryptocoins_icons') { ?>
                    <?php if($mt_font_cryptocoins_icons) { ?>
                      <?php $icon_feature = '<i class="'.esc_attr($mt_font_cryptocoins_icons).'"></i>'; ?>
                    <?php } ?>
                  <?php } elseif (isset($mt_select_font) && $mt_select_font == 'font_awesome_icons') { ?>
                    <?php if($mt_font_awesome_icons) { ?>
                      <?php $icon_feature = '<i class="'.esc_attr($mt_font_awesome_icons).'"></i>'; ?>
                    <?php } ?>
                  <?php } elseif (isset($mt_select_font) && $mt_select_font == 'simple_line_icons') { ?>
                    <?php if($mt_font_simple_line) { ?>
                      <?php $icon_feature = '<i class="'.esc_attr($mt_font_simple_line).'"></i>'; ?>
                    <?php } ?>
                  <?php } ?>
                  <?php if ($thumbnail_src) {
                      $post_img = '<img class="blog_post_image" src="'. esc_url($thumbnail_src[0]) . '" alt="'.$blogpost->post_title.'" />';
                  }else{
                      $post_img = $icon_feature;
                  }
                  
                  $content_post   = get_post($blogpost->ID);
                  $content        = $content_post->post_content;
                  $content        = apply_filters('the_content', $content);
                  $content        = str_replace(']]>', ']]&gt;', $content);
                  $comments_count = wp_count_comments($blogpost->ID);
                  if($comments_count->approved >= 1) {
                      $comments = __('Comments','mtlisitings').' <a href="'.get_comments_link($blogpost->ID).'">'. $comments_count->approved.'</a>';
                  } else {
                      $comments = __('No comments','mtlisitings');
                  }
                  $term_list = wp_get_post_terms($blogpost->ID, 'mt-listing-category');
                  // var_dump($term_list);
                  $term_list_categories = wp_get_post_terms($blogpost->ID, 'mt-listing-category2');
                  $sticky_class = '';
                  if ( is_sticky($blogpost->ID) ) {
                      $sticky_class = 'is-sticky';
                  }
                  $mt_listing_received_without_comma = str_replace( ',', '', $mt_listing_received );
                  $mt_listing_goal_money_without_comma = str_replace( ',', '', $mt_listing_fundraising_goal );
                  $mt_listing_received_without_dollar = str_replace( '$', '', $mt_listing_received_without_comma );
                  $mt_listing_goal_without_dollar = str_replace( '$', '', $mt_listing_goal_money_without_comma );
                  if(!empty($mt_listing_received_without_dollar) && !empty($mt_listing_goal_without_dollar)) {
                    if (is_numeric($mt_listing_received_without_dollar) && is_numeric($mt_listing_goal_without_dollar)) {
                      $percentage = ( $mt_listing_received_without_dollar * 100 ) / $mt_listing_goal_without_dollar; 
                    }
                    
                  }
                  $mt_select_rating_star_recent = get_post_meta( $blogpost->ID, 'mt_select_rating_star', true );
                                                    
                  if(!empty($mt_select_rating_star_recent)) {
                    $percentage_rating_recent = $mt_select_rating_star_recent;
                  } else {
                    $percentage_rating_recent = '0%';
                  }        
                  $now = time(); // or your date as well
                  $your_date = strtotime($mt_listing_end_date_pick);
                  $datediff = $now - $your_date;
                  $date_dif = abs(round($datediff / (60 * 60 * 24)));    

                  // TAXONOMY PHOTO/ICON
                  $taxonomy_image_id = get_term_meta ( $term_list_categories[0]->term_id, 'category-image-id', true );
                  $tax_img = '';
                  if (wp_get_attachment_image ( $taxonomy_image_id, 'thumbnail' )) {
                    $tax_img = wp_get_attachment_image ( $taxonomy_image_id, 'thumbnail' );
                  }

                  $last_item_row = '';
                  if ($items_per_row == 'col-md-12') {
                    $items_per_row_new = 'row-1items';
                  }elseif ($items_per_row == 'col-md-6') {
                    $items_per_row_new = 'row-2items';
                    if ($i%2 == 0) {
                      $last_item_row = 'last_item_row';
                    }
                  }elseif ($items_per_row == 'col-md-4') {
                    $items_per_row_new = 'row-3items';
                    if ($i%3 == 0) {
                      $last_item_row = 'last_item_row';
                    }
                  }elseif ($items_per_row == 'col-md-3') {
                    $items_per_row_new = 'row-4items';
                    if ($i%4 == 0) {
                      $last_item_row = 'last_item_row';
                    }
                  }

              if ($cat_position == '0') {
                  if ($i == 3) {
                    if (($items_per_row == 'col-md-12') && numismatico_redux('mt_adplace_ico_list')) {
                      if(numismatico_redux('mt_adplace_ico_list_adsense_code') != '' && numismatico_redux('mt_adplace_ico_list') == 'on_adsense'){
                        echo numismatico_redux('mt_adplace_ico_list_adsense_code');
                      }elseif(numismatico_redux('mt_adplace_ico_list_img_1_1','url') != '' && numismatico_redux('mt_adplace_ico_list') == 'on'){
                        $html .= '<div class="'.$items_per_row.' '.$items_per_row_new.' adplace-'.$items_per_row_new.'">
                                  <div class="post '.esc_attr($sticky_class).' '.esc_attr($mt_listing_sponsored_status).'">
                                        <a href="'. esc_url(numismatico_redux('mt_adplace_ico_list_link')) .'" target="_blank">
                                            <img src="'. esc_url(numismatico_redux('mt_adplace_ico_list_img_1_1','url')) .'" alt="" />
                                        </a>
                                  </div>
                                </div>';
                      }
                    }elseif(($items_per_row == 'col-md-4') && numismatico_redux('mt_adplace_ico_list')){
                      if(numismatico_redux('mt_adplace_ico_list_adsense_code') != '' && numismatico_redux('mt_adplace_ico_list') == 'on_adsense'){
                        echo numismatico_redux('mt_adplace_ico_list_adsense_code');
                      }elseif(numismatico_redux('mt_adplace_ico_list_img_1_3','url') != '' && numismatico_redux('mt_adplace_ico_list') == 'on'){
                      $html .= '<div class="'.$items_per_row.' '.$items_per_row_new.' adplace-'.$items_per_row_new.'">
                                  <div class="post '.esc_attr($sticky_class).' '.esc_attr($mt_listing_sponsored_status).'">
                                        <a href="'. esc_url(numismatico_redux('mt_adplace_ico_list_link')) .'" target="_blank">
                                            <img src="'. esc_url(numismatico_redux('mt_adplace_ico_list_img_1_3','url')) .'" alt="" />
                                        </a>
                                  </div>
                                </div>
                                <div class="clearfix"></div>';
                      }
                    }
                  }

                  if ($i == 2) {
                      if (($items_per_row == 'col-md-6') && numismatico_redux('mt_adplace_ico_list')){
                        if(numismatico_redux('mt_adplace_ico_list_adsense_code') != '' && numismatico_redux('mt_adplace_ico_list') == 'on_adsense'){
                          echo numismatico_redux('mt_adplace_ico_list_adsense_code');
                        }elseif(numismatico_redux('mt_adplace_ico_list_img_1_2','url') != '' && numismatico_redux('mt_adplace_ico_list') == 'on'){  
                      $html .= '<div class="'.$items_per_row.' '.$items_per_row_new.' adplace-'.$items_per_row_new.'">
                                  <div class="post '.esc_attr($sticky_class).' '.esc_attr($mt_listing_sponsored_status).'">
                                        <a href="'. esc_url(numismatico_redux('mt_adplace_ico_list_link')) .'" target="_blank">
                                            <img src="'. esc_url(numismatico_redux('mt_adplace_ico_list_img_1_2','url')) .'" alt="" />
                                        </a>
                                  </div>
                                </div>
                                <div class="clearfix"></div>';
                      }
                    }
                  }

                  if ($i == 4) {
                    if (($items_per_row == 'col-md-3') && numismatico_redux('mt_adplace_ico_list')) {
                       if(numismatico_redux('mt_adplace_ico_list_adsense_code') != '' && numismatico_redux('mt_adplace_ico_list') == 'on_adsense'){
                          echo numismatico_redux('mt_adplace_ico_list_adsense_code');
                        }elseif(numismatico_redux('mt_adplace_ico_list_img_1_2','url') != '' && numismatico_redux('mt_adplace_ico_list') == 'on'){  
                      $html .= '<div class="'.$items_per_row.' '.$items_per_row_new.' adplace-'.$items_per_row_new.'">
                                  <div class="post '.esc_attr($sticky_class).' '.esc_attr($mt_listing_sponsored_status).'">
                                        <a href="'. esc_url(numismatico_redux('mt_adplace_ico_list_link')) .'" target="_blank">
                                            <img src="'. esc_url(numismatico_redux('mt_adplace_ico_list_img_1_4','url')) .'" alt="" />
                                        </a>
                                  </div>
                                </div>
                                <div class="clearfix"></div>';
                    }
                  }
                }
              }

                  $html.='<div class="'.$items_per_row.' '.$items_per_row_new.' '.$last_item_row.' numismatico-single-list-item mix '.esc_attr($term_list[0]->slug).' '.$blogpost->post_title.' '.esc_attr($term_list_categories[0]->slug).'">
                            <div class="post '.esc_attr($sticky_class).' '.esc_attr($mt_listing_sponsored_status).'">
                              <div class="blog_custom_listings">
                                <div class="row">
                                  <div class="numismatico-img-left pull-left">
                                    <a class="relative" href="'.get_permalink($blogpost->ID).'">'.$post_img.'</a>
                                  </div>';

                                  // COMPARE DATES
                                  $mt_listing_end_date_pick_new_format = date('Y-m-d H:i:s', strtotime($mt_listing_end_date_pick));
                                  $todaydate = date("Y-m-d H:i:s");

                                  if($todaydate > $mt_listing_end_date_pick_new_format){
                                    $end_label = esc_html__('Ended: ' ,'mtlisitings') . date('M m, Y', strtotime($mt_listing_end_date_pick));
                                  }else{
                                    $end_label = date('M m, Y', strtotime($mt_listing_end_date_pick));
                                  }

                         $html.='<div class="numismatico-details-title pull-left">

                                    <h4 class="post-name-listings"><a href="'.get_permalink($blogpost->ID).'">'.$blogpost->post_title.'</a>
                                      <span>
                                        <i class="fa fa-calendar-times-o"></i>'.$end_label.'
                                      </span>
                                    </h4>';
                                  if (!empty($mt_select_rating_star)) {
                                    $html.='<div class="mt-ico-rating">
                                      <div class="mt-ico-rating-empty"></div>
                                      <div class="mt-ico-rating-fill" style="width: '.esc_attr($mt_select_rating_star).'"></div>
                                    </div>';
                                  }
                         $html.='</div>';

                        $html.='<div class="numismatico-details pull-left">';
                                    
                                  if (($items_per_row == 'col-md-12')) {
                                    $html .= '<p class="numismatico-details-content">'.esc_attr($my_excerpt).'</p>';
                                  }elseif ($items_per_row == 'col-md-4') {
                                    $html .= '<p class="numismatico-details-content">'.strip_tags(mtlisitings_excerpt_limit($my_excerpt, 8)).' (...)</p>';
                                  }elseif ($items_per_row == 'col-md-3') {
                                    $html .= '<p class="numismatico-details-content">'.strip_tags(mtlisitings_excerpt_limit($my_excerpt, 8)).' (...)</p>';
                                  }elseif ($items_per_row == 'col-md-6') {
                                    $html .= '<p class="numismatico-details-content">'.strip_tags(mtlisitings_excerpt_limit($my_excerpt, 12)).' (...)</p>';
                                  }

                                  $html.='<div class="listings_details">                                
                
                                    <div class="clearfix"></div>
                                    <div class="numismatico-metas">
                                      <div class="numismatico-metas-single-meta pull-left ico-type">
                                        <div><i class="fa fa-check-circle"></i> '.esc_attr($term_list[0]->name).'</div>
                                      </div>
                                      
                                      <div class="numismatico-metas-single-meta pull-left ico-category">
                                        <div>'. $tax_img . esc_attr($term_list_categories[0]->name).'</div>
                                      </div>
                                    </div>
                                  </div>


                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>';

                $i++;
                }

                $html .= '</div>';
                $html .= '<div class="clearfix"></div>';

                $html .= '<div class="ico-cat-parent-title ico-cat-parent-subtitle" style="background:'.$btn_background_color_normal.' !important;">
                            <a class="text-center" href="'.get_category_link( $mt_listing_single_cat->term_id ).'">'.esc_html__('View all items from the ', 'mtlisitings').$mt_listing_single_cat->cat_name.' ('.$mt_listing_single_cat->category_count.')</a>
                          </div>';

              $html .= '</div>';

              $cat_position++;
            }
            $html .= '</div>';
          $html .= '</section>';
        $html .= '</div>';
      $html .= '</div>';
    $html .= '</div>';
    return $html;
}
add_shortcode('icofilters', 'modeltheme_shortcode_icofilters');
/**
||-> Map Shortcode in Visual Composer with: vc_map();
*/
if ( is_plugin_active( 'js_composer/js_composer.php' ) ) {
  require_once __DIR__ . '/../vc-shortcodes.inc.arrays.php';
  
  $filter_sidebar = array(
    __('Choose', 'mtlisitings') => 'Null',
    __('Sidebar Enable ', 'mtlisitings') => 'sidebar_on', 
    __('Sidebar Disable', 'mtlisitings') => 'sidebar_off'
  );
  $search_filter = array(
    __('Choose', 'mtlisitings') => 'Null',
    __('Search Enable ', 'mtlisitings') => 'search_on', 
    __('Search Disable', 'mtlisitings') => 'search_off'
  );
  $categories_filter = array(
    __('Choose', 'mtlisitings') => 'Null',
    __('Categories Enable ', 'mtlisitings') => 'categories_on', 
    __('Categories Disable', 'mtlisitings') => 'categories_off'
  );

  vc_map( array(
     "name" => esc_attr__("MT - Ico Filters", 'mtlisitings'),
     "base" => "icofilters",
     "category" => esc_attr__('MT: ModelTheme', 'mtlisitings'),
     "icon" => "smartowl_shortcode",
     "params" => array(
        array(
            "group" => "Options",
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => esc_attr__("Style Variant", 'mtlisitings'),
            "param_name" => "mtlistings_style_variant",
            "std" => '',
            "description" => "",
            "value" => array(
                esc_attr__('Style 1', 'mtlisitings')         => 'mtlistings-ico-style-v1',
                esc_attr__('Style 2', 'mtlisitings')         => 'mtlistings-ico-style-v2',
            )
        ),
        array(
          "group" => "Options",
          "type" => "textfield",
          "holder" => "div",
          "class" => "",
          "heading" => esc_attr__( "Number of posts", 'mtlisitings' ),
          "param_name" => "number",
          "value" => "",
          "description" => esc_attr__( "Enter number of blog post to show.", 'mtlisitings' )
        ),
        array(
            "group" => "Options",
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => esc_attr__("Items Per Row", 'mtlisitings'),
            "param_name" => "items_per_row",
            "std" => '',
            "description" => "",
            "value" => array(
                esc_attr__('1 Items/Row', 'mtlisitings')         => 'col-md-12',
                esc_attr__('2 Items/Row', 'mtlisitings')         => 'col-md-6',
                esc_attr__('3 Items/Row', 'mtlisitings')         => 'col-md-4',
                esc_attr__('4 Items/Row', 'mtlisitings')         => 'col-md-3',
            )
        ),
        array(
          "group" => "Options",
          "type" => "textfield",
          "heading" => __("Extra class name", "modeltheme"),
          "param_name" => "extra_class",
          "description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "modeltheme")
        ),
        array(
          "group" => "Filters",
          "type" => "dropdown",
          "holder" => "div",
          "heading" => esc_attr__( "Enable or disable filter sidebar", 'mtlisitings' ),
          "param_name" => "filtersidebar",
          "value" => $filter_sidebar,
        ),
        array(
          "group" => "Filters",
          "type" => "dropdown",
          "holder" => "div",
          "heading" => esc_attr__( "Enable or disable search on filter sidebar", 'mtlisitings' ),
          "param_name" => "searchfilter",
          "value" => $search_filter,
        ),
        array(
          "group" => "Animation",
          "type" => "dropdown",
          "heading" => esc_attr__("Animation", 'mtlisitings'),
          "param_name" => "animation",
          "std" => 'fadeInLeft',
          "holder" => "div",
          "class" => "",
          "description" => "",
          "value" => $animations_list
        ),
        array(
          "group" => "Styling",
          "type" => "colorpicker",
          "class" => "",
          "heading" => esc_attr__( "Title color", 'mtlisitings' ),
          "param_name" => "title_color",
          "value" => ""
        ),
        array(
          "group" => "Styling",
          "type" => "colorpicker",
          "class" => "",
          "heading" => esc_attr__( "Description color", 'mtlisitings' ),
          "param_name" => "desc_color",
          "value" => ""
        ),
        array(
          "group" => "Styling",
          "type" => "colorpicker",
          "class" => "",
          "heading" => esc_attr__( "Title Background", 'mtlisitings' ),
          "param_name" => "title_bg",
          "value" => ""
        ),
        array(
          "group" => "Styling",
          "type" => "colorpicker",
          "class" => "",
          "heading" => esc_attr__( "'View All...' Button Background", 'mtlisitings' ),
          "param_name" => "btn_background_color_normal",
          "value" => ""
        ),
        array(
          "group" => "Styling",
          "type" => "colorpicker",
          "class" => "",
          "heading" => esc_attr__( "'View All...' Button Background Hover", 'mtlisitings' ),
          "param_name" => "btn_background_color_normal_hover",
          "value" => ""
        )
      )
  ));
}