<?php 
/**
* Template for Listings
* Used in: taxonomy-mt-car-category.php, taxonomy-mt-car-features.php, taxonomy-mt-car-type.php, search.php
**/

  // List THUMBNAIL
  $post_img = '';
  $thumbnail_src_featured = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'numismatico_listing_archive_featured_square' );
  $thumbnail_src_thumbnail = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'numismatico_listing_archive_thumbnail' );
  if ($thumbnail_src_featured) {
    $post_img = '<img class="blog_post_image" src="'. esc_url($thumbnail_src_featured[0]) . '" alt="'.get_the_title().'" />';
    $post_img_modal = '<img class="blog_post_image" src="'. esc_url($thumbnail_src_featured[0]) . '" alt="'.get_the_title().'" width="130" height="130"/>';
    $post_col = 'col-md-6';
  } 
  else {
    $post_col = 'col-md-12 no-featured-image';
  }    
  $mt_listing_interest = get_post_meta( get_the_ID(), 'mt_listing_interest', true );
  $mt_listing_category = get_post_meta( get_the_ID(), 'mt_listing_category', true );
  $mt_listing_start_date_pick = get_post_meta( get_the_ID(), 'mt_listing_start_date_pick', true );
  $mt_listing_end_date_pick = get_post_meta( get_the_ID(), 'mt_listing_end_date_pick', true );
  $mt_listing_website_button = get_post_meta( get_the_ID(), 'mt_listing_website_button', true );
  $mt_listing_whitepaper_button = get_post_meta( get_the_ID(), 'mt_listing_whitepaper_button', true );
  $mt_listing_purchase_button = get_post_meta( get_the_ID(), 'mt_listing_purchase_button', true );
  $mt_listing_facebook = get_post_meta( get_the_ID(), 'mt_listing_facebook', true );
  $mt_listing_twitter = get_post_meta( get_the_ID(), 'mt_listing_twitter', true );
  $mt_listing_github = get_post_meta( get_the_ID(), 'mt_listing_github', true );
  $mt_listing_joinchat = get_post_meta( get_the_ID(), 'mt_listing_joinchat', true );
  $mt_listing_linkedin = get_post_meta( get_the_ID(), 'mt_listing_linkedin', true );
  $mt_listing_medium = get_post_meta( get_the_ID(), 'mt_listing_medium', true );
  $mt_listing_youtube = get_post_meta( get_the_ID(), 'mt_listing_youtube', true );
  $mt_listing_bitcointalk = get_post_meta( get_the_ID(), 'mt_listing_bitcointalk', true );
  $mt_video_tour = get_post_meta( get_the_ID(), 'mt_video_tour', true );
  $mt_listing_token_sale_date = get_post_meta( get_the_ID(), 'mt_listing_token_sale_date', true );
  $mt_listing_ticker = get_post_meta( get_the_ID(), 'mt_listing_ticker', true );
  $mt_listing_ico_token_price = get_post_meta( get_the_ID(), 'mt_listing_ico_token_price', true );
  $mt_listing_fundraising_goal = get_post_meta( get_the_ID(), 'mt_listing_fundraising_goal', true );
  $mt_listing_sold_on_pre_sale = get_post_meta( get_the_ID(), 'mt_listing_sold_on_pre_sale', true );
  $mt_listing_total_tokens = get_post_meta( get_the_ID(), 'mt_listing_total_tokens', true );
  $mt_listing_available_for_token_sale = get_post_meta( get_the_ID(), 'mt_listing_available_for_token_sale', true );
  $mt_listing_kyc = get_post_meta( get_the_ID(), 'mt_listing_kyc', true );
  $mt_listing_cant_participate = get_post_meta( get_the_ID(), 'mt_listing_cant_participate', true );
  $mt_listing_accepts = get_post_meta( get_the_ID(), 'mt_listing_accepts', true );
  $mt_listing_competition_coins = get_post_meta( get_the_ID(), 'mt_listing_competition_coins', true );
  $mt_listing_prototype_url = get_post_meta( get_the_ID(), 'mt_listing_prototype_url', true );
  $mt_select_font = get_post_meta( get_the_ID(), 'mt_select_font', true );
  $mt_font_cryptocoins_icons = get_post_meta( get_the_ID(), 'mt_font_cryptocoins_icons', true );
  $mt_font_awesome_icons = get_post_meta( get_the_ID(), 'mt_font_awesome_icons', true );
  $mt_font_simple_line = get_post_meta( get_the_ID(), 'mt_font_simple_line_icons', true );
  $mt_select_rating_star = get_post_meta( get_the_ID(), 'mt_select_rating_star', true );
  $mt_listing_other_tokens = get_post_meta( get_the_ID(), 'mt_listing_other_tokens', true );
  $mt_listing_team_tokens = get_post_meta( get_the_ID(), 'mt_listing_team_tokens', true );
  $mt_listing_ico_token_price = get_post_meta( get_the_ID(), 'mt_listing_ico_token_price', true );
  $mt_listing_token_type = get_post_meta( get_the_ID(), 'mt_listing_token_type', true );
  $mt_listing_role_token = get_post_meta( get_the_ID(), 'mt_listing_role_token', true );
  $mt_listing_style = get_post_meta( get_the_ID(), 'mt_listing_style', true );

  $ico_replacement = __('ICO', 'mtlisitings');
  $ico_replacement_plural = __('ICOs', 'mtlisitings');
  if (function_exists('icoswitch_is_cpt_title_singular')) {
    if (icoswitch_is_cpt_title_singular()) {
      $ico_replacement = icoswitch_is_cpt_title_singular();
    }
  }
  if (function_exists('icoswitch_is_cpt_title_plural')) {
    if (icoswitch_is_cpt_title_plural()) {
      $ico_replacement_plural = icoswitch_is_cpt_title_plural();
    }
  }
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('post'.' '. $mt_listing_style); ?>>
  <div class="row single-icondrops">
    <div class="container main-content padding-left_0 padding-right_0">
      <div class="row main-row">
      <div class="col-md-10">
        <div class="row ico-info">
          <div class="col-md-2">
            <?php if (!empty($post_img)) { ?>
              <?php echo wp_kses_post($post_img); ?>
            <?php } else { ?>
              <div class="featured-icon">
                
                <?php if (isset($mt_select_font) && $mt_select_font == 'cryptocoins_icons') { ?>
                  <?php if($mt_font_cryptocoins_icons) { ?>
                    <i class="<?php echo esc_attr($mt_font_cryptocoins_icons); ?>"></i>
                  <?php } ?>
                <?php } elseif (isset($mt_select_font) && $mt_select_font == 'font_awesome_icons') { ?>
                  <?php if($mt_font_awesome_icons) { ?>
                    <i class="<?php echo esc_attr($mt_font_awesome_icons); ?>"></i>
                  <?php } ?>
                <?php } elseif (isset($mt_select_font) && $mt_select_font == 'simple_line_icons') { ?>
                  <?php if($mt_font_simple_line) { ?>
                    <i class="<?php echo esc_attr($mt_font_simple_line); ?>"></i>
                  <?php } ?>
                <?php } ?>
              </div>
            <?php } ?>
          </div>

          <div class="col-md-4">
            <h1 class="list_title">
              <?php echo get_the_title(); ?>
            </h1>
            <?php $term_list = wp_get_post_terms(get_the_ID(), 'mt-listing-category2'); ?> 
            <?php if (!empty($term_list[0]->name)) { ?>
              <h4 class="mt_listing_category">
                <a href="<?php echo esc_url(get_term_link($term_list[0]->name, 'mt-listing-category2')); ?>">
                  <?php echo esc_attr($term_list[0]->name); ?>
                </a>
              </h4>
            <?php } ?>

            <?php if(isset($mt_listing_ico_token_price) && $mt_listing_ico_token_price != ''){ ?>
              <p><?php echo $mt_listing_ico_token_price; ?></p>
            <?php } ?>

            <?php if (!empty($mt_select_rating_star)) { ?>
              <div class="mt-ico-rating">
                <div class="mt-ico-rating-empty"></div>
                <div class="mt-ico-rating-fill" style="width: <?php echo esc_attr($mt_select_rating_star); ?>"></div>
              </div>
            <?php } ?>
          </div>

          <div class="col-md-6">
              <?php
              echo '<span class="single-ico-share">
                      <ul class="single-ico-social-sharer">
                          <li class="facebook">
                              <a target="_blank" data-toggle="tooltip" title="'.esc_html__('Share on Facebook','mtlisitings').'" data-placement="top" href="http://www.facebook.com/share.php?u='.get_permalink().'&amp;title='.get_the_title().'"><i class="fa fa-facebook"></i></a>
                          </li>
                          <li class="twitter">
                              <a target="_blank" data-toggle="tooltip" title="'.esc_html__('Share on Twitter','mtlisitings').'" data-placement="top" href="http://twitter.com/home?status='.get_the_title().'+'.get_permalink().'"><i class="fa fa-twitter"></i></a>
                          </li>
                          <li class="linkedin">
                              <a target="_blank" data-toggle="tooltip" title="'.esc_html__('Share on LinkedIn','mtlisitings').'" data-placement="top" href="http://www.linkedin.com/shareArticle?mini=true&amp;url='.get_permalink().'&amp;title='.get_the_title().'&amp;source='.get_permalink().'"><i class="fa fa-linkedin"></i></a>
                          </li>
                          <li class="google-plus">
                              <a target="_blank" data-toggle="tooltip" title="'.esc_html__('Share on Google','mtlisitings').'" data-placement="top" href="https://plus.google.com/share?url='.get_permalink().'"><i class="fa fa-google"></i></a>
                          </li>
                          <li class="pinterest">
                              <a target="_blank" data-toggle="tooltip" title="'.esc_html__('Pin on Pinterest','mtlisitings').'" data-placement="top" href="http://pinterest.com/pin/create/bookmarklet/?media='.get_permalink().'&url='.get_permalink().'&is_video=false&description='.get_permalink().'"><i class="fa fa-pinterest-p"></i></a>
                          </li>
                          <li class="reddit">
                              <a target="_blank" data-toggle="tooltip" title="'.esc_html__('Share on Reddit','mtlisitings').'" data-placement="top" href="http://www.reddit.com/submit?url='.get_permalink().'&amp;title='.get_the_title().'"><i class="fa fa-reddit-alien"></i></a>
                          </li>
                          <li class="tumblr">
                              <a target="_blank" data-toggle="tooltip" title="'.esc_html__('Share on Tumblr','mtlisitings').'" data-placement="top" href="http://www.tumblr.com/share?v=3&amp;u='.get_permalink().'&amp;t='.get_the_title().'"><i class="fa fa-tumblr"></i></a>
                          </li>
                          <li class="embed">
                              <button type="button" class="btn btn-info" data-toggle="modal" data-target="#embed-modal"><i class="fa fa-code"></i> '.esc_html__('Embed', 'mtlisitings').'</button>
                          </li>'
                          ?>
                          <!-- Modal -->
                          <div class="modal fade" id="embed-modal" role="dialog">
                            <div class="modal-dialog">
                            
                              <!-- Modal content-->
                              <div class="embed-modal-content modal-content">
                                <div class="modal-header">
                                  <button type="button" class="close" data-dismiss="modal">&times;</button>
                                  <h4 class="modal-title"><?php echo esc_html__('Add this Embed to your website, blog, or article','mtlisitings'); ?></h4>
                                </div>
                                <div class="modal-body">
                                    <div class="modal-body-view">
                                      <div style="padding: 30px; border: 2px solid #e5e3eb; border-radius: 5px;">
                                        <div style="display: inline-block; margin: 0 10px 10px 0">
                                            <a href="<?php echo get_permalink() ?>" title="<?php echo get_the_title(); ?>"><?php if (!empty($post_img_modal)) { ?>
                                                    <?php echo wp_kses_post($post_img_modal); ?>
                                                  <?php } else { ?>
                                                    <div class="featured-icon">
                                                      <?php if (isset($mt_select_font) && $mt_select_font == 'cryptocoins_icons') { ?>
                                                        <?php if($mt_font_cryptocoins_icons) { ?>
                                                          <i class="<?php echo esc_attr($mt_font_cryptocoins_icons); ?>"></i>
                                                        <?php } ?>
                                                      <?php } elseif (isset($mt_select_font) && $mt_select_font == 'font_awesome_icons') { ?>
                                                        <?php if($mt_font_awesome_icons) { ?>
                                                          <i class="<?php echo esc_attr($mt_font_awesome_icons); ?>"></i>
                                                        <?php } ?>
                                                      <?php } elseif (isset($mt_select_font) && $mt_select_font == 'simple_line_icons') { ?>
                                                        <?php if($mt_font_simple_line) { ?>
                                                          <i class="<?php echo esc_attr($mt_font_simple_line); ?>"></i>
                                                        <?php } ?>
                                                      <?php } ?>
                                                    </div>
                                                  <?php } ?>
                                            </a>
                                          </div>
                                          <div style="display: inline-block; vertical-align: middle;">
                                              <a href="<?php echo get_permalink() ?>" title="<?php echo get_the_title(); ?>" style="font-size: 28px; font-weight: bold;"><?php echo get_the_title(); ?></a>
                                              <p style="font-size: 20px; font-weight: bold; color: #6CD087; margin-bottom: 5px;">(<?php $term_list = wp_get_post_terms(get_the_ID(), 'mt-listing-category2'); ?><?php echo esc_attr($term_list[0]->name); ?>)</p>
                                              <p style="font-size: 14px; font-weight: 300;"><?php if (!empty($mt_listing_end_date_pick)) { ?>
                                  <?php $mt_listing_end_date_pick_wp_format = date(get_option('date_format'), strtotime($mt_listing_end_date_pick));?>
                                      <i class="fa fa-calendar-times-o"></i> <?php echo esc_html($mt_listing_end_date_pick_wp_format); ?>
                              <?php } ?>
                            </p>
                                        </div>
                                        <div>
                                            <?php the_excerpt(); ?>
                                            <a href="<?php echo get_permalink() ?>" title="<?php echo get_the_title(); ?>" style="color: #ffffff; background: #6CD086; padding: 3px 10px; border-radius: 3px;"><?php echo esc_html__('Read more', 'mtlisitings'); ?></a><span style="color:#a7a7a7; float: right;">Powered by: <a href="<?php echo esc_url(get_site_url()); ?>" title="<?php echo esc_attr(get_bloginfo()); ?>" style="color: #6CD086; font-weight: bold; font-style: italic;"><?php echo esc_attr(get_bloginfo('name')); ?></a></span>
                                          </div>
                                        </div>
                                    </div>
                                    <textarea id="modal-embed-textarea" style="width: 100%; font-size: 13px;" rows="3" spellcheck="false">
<div style="padding: 30px; border: 2px solid #e5e3eb; border-radius: 5px;"><div style="display: inline-block; margin: 0 10px 10px 0"><a href="<?php echo get_permalink() ?>" title="<?php echo get_the_title(); ?>"><?php if (!empty($post_img_modal)) { ?><?php echo wp_kses_post($post_img_modal); ?><?php } else { ?><div class="featured-icon"><?php if (isset($mt_select_font) && $mt_select_font == 'cryptocoins_icons') { ?><?php if($mt_font_cryptocoins_icons) { ?><i class="<?php echo esc_attr($mt_font_cryptocoins_icons); ?>"></i><?php } ?><?php } elseif (isset($mt_select_font) && $mt_select_font == 'font_awesome_icons') { ?><?php if($mt_font_awesome_icons) { ?><i class="<?php echo esc_attr($mt_font_awesome_icons); ?>"></i><?php } ?><?php } elseif (isset($mt_select_font) && $mt_select_font == 'simple_line_icons') { ?><?php if($mt_font_simple_line) { ?><i class="<?php echo esc_attr($mt_font_simple_line); ?>"></i><?php } ?><?php } ?></div><?php } ?></a></div><div style="display: inline-block; vertical-align: middle;"><a href="<?php echo get_permalink() ?>" title="<?php echo get_the_title(); ?>" style="font-size: 28px; font-weight: bold;"><?php echo get_the_title(); ?></a><p style="font-size: 20px; font-weight: bold; color: #6CD087; margin-bottom: 5px;">(<?php $term_list = wp_get_post_terms(get_the_ID(), 'mt-listing-category2'); ?><?php echo esc_attr($term_list[0]->name); ?>)</p><p style="font-size: 14px; font-weight: 300;"><?php if (!empty($mt_listing_end_date_pick)) { ?><?php $mt_listing_end_date_pick_wp_format = date(get_option('date_format'), strtotime($mt_listing_end_date_pick));?><i class="fa fa-calendar-times-o"></i> <?php echo esc_html($mt_listing_end_date_pick_wp_format); ?><?php } ?></p></div><div><?php the_excerpt(); ?><a href="<?php echo get_permalink() ?>" title="<?php echo get_the_title(); ?>" style="color: #ffffff; background: #6CD086; padding: 3px 10px; border-radius: 3px;">Read more</a><span style="color:#a7a7a7; float: right;">Powered by: <a href="<?php echo esc_url(get_site_url()); ?>" title="<?php echo esc_attr(get_bloginfo()); ?>" style="color: #6CD086; font-weight: bold; font-style: italic;"><?php echo esc_attr(get_bloginfo('name')); ?></a></span></div></div></textarea>
                                    <button id="modal-embed-copy"><?php echo esc_html__('Copy','mtlisitings'); ?></button>
                                </div>
                                <div class="modal-footer">
                                  <button type="button" class="btn" data-dismiss="modal"><?php echo esc_html__('Close','mtlisitings'); ?></button>
                                </div>
                              </div>
                              
                            </div>
                          </div>
                     <?php '</ul>
                  </span>'
              ?>
          </div>

          <div class="col-md-12">
            <div class="list_excerpt">
              <?php the_excerpt(); ?>
            </div>
          </div>

          <div class="col-md-12 ico-info-button">
            <div class="mt_listing_button">
              <?php if (!empty($mt_listing_purchase_button)) { ?>
                <a target="_blank" href="<?php echo esc_attr($mt_listing_purchase_button); ?>" class="mt_listing_purchase_button">
                  <i class="fa fa-shopping-basket" aria-hidden="true"></i> <?php echo esc_html__('Purchase ','mtlisitings') . get_the_title(); ?>           
                </a>
              <?php } ?>
              
              <?php if (!empty($mt_video_tour)) { ?>
                <a class="popup-vimeo-youtube mt_listing_video_button" href="<?php echo esc_attr($mt_video_tour); ?>" data-src=""><i class="fa fa-play" aria-hidden="true"></i> <?php esc_html_e('Video','mtlisitings'); ?></a>
            <?php } ?>

            <?php if (!empty($mt_listing_whitepaper_button)) { ?>
                <a target="_blank" href="<?php echo esc_attr($mt_listing_whitepaper_button); ?>" class="mt_listing_whitepaper_button">
                  <i class="fa fa-file-text-o" aria-hidden="true"></i> <?php esc_html_e('Whitepaper','mtlisitings'); ?>              
                </a>
              <?php } ?>

            <?php if (!empty($mt_listing_website_button)) { ?>
                <a target="_blank" href="<?php echo esc_attr($mt_listing_website_button); ?>" class="mt_listing_website_button">
                  <i class="fa fa-external-link" aria-hidden="true"></i> <?php esc_html_e('Website','mtlisitings'); ?>           
                </a>
            <?php } ?>
            </div>
          </div>

          <div class="col-md-4">
            <div class="mt_listing_countdown">

              <?php
              $date_modified = date("Y/n/j", strtotime($mt_listing_end_date_pick));
              echo do_shortcode('[mt-countdown date="'.$date_modified.'"]');
              ?>
            </div>
          </div>

          <div class="col-md-8 ico-info-date">
            <?php if (!empty($mt_listing_start_date_pick)) { ?>


              <div class="mt_listing_start_date_pick">
                <?php esc_html_e(' Start Date: ' ,'mtlisitings'); ?>
                <h3 class="mt_listing_date">                                   
                  <?php $mt_listing_start_date_pick_new_format = date(get_option('date_format'), strtotime($mt_listing_start_date_pick)); echo esc_html($mt_listing_start_date_pick_new_format); ?>   
                </h3>
              </div>
            <?php } ?>

            <?php if (!empty($mt_listing_end_date_pick)) { ?>
             <div class="mt_listing_end_date_pick">
                <?php
                // FORMAT DATES for ECHO
                $mt_listing_end_date_pick_wp_format = date(get_option('date_format'), strtotime($mt_listing_end_date_pick));

                // COMPARE DATES
                $mt_listing_end_date_pick_new_format = date('Y-m-d H:i:s', strtotime($mt_listing_end_date_pick));
                $todaydate = date("Y-m-d H:i:s");

                if($todaydate > $mt_listing_end_date_pick_new_format){
                  esc_html_e('Token Sale Ended: ' ,'mtlisitings');
                }else{
                  echo esc_html($ico_replacement);
                  esc_html_e(' Ends Date: ' ,'mtlisitings');
                } ?>
                <h3 class="mt_listing_date">                                   
                  <?php echo esc_html($mt_listing_end_date_pick_wp_format); ?>
                </h3>
             </div>
            <?php } ?>
          </div>

        </div>
      </div>

      <div class="col-md-2 rating-margin-top">
        <div class="mt-post-ratings">
          <?php echo do_shortcode('[thumbs-rating-buttons]'); ?>
        </div>
      </div>
      <div class="col-md-12 single-icondrops-adplace-top">
        



                    <?php if (numismatico_redux('mt_adplace_single')) {
                      if(numismatico_redux('mt_adplace_single_adsense_code') != '' && numismatico_redux('mt_adplace_single') == 'on_adsense'){
                        echo numismatico_redux('mt_adplace_single_adsense_code');
                      }elseif(numismatico_redux('mt_adplace_single_top_img','url') != '' && numismatico_redux('mt_adplace_single') == 'on'){ ?>
                        <div class="single-icondrops-adplace-top-content">
                                        <a href="<?php echo esc_url(numismatico_redux('mt_adplace_single_top_link')) ?>" target="_blank">
                                            <img src="<?php echo esc_url(numismatico_redux('mt_adplace_single_top_img','url')) ?>" alt="" />
                                        </a>
                                </div>
                      <?php }
                    } ?>


      </div>
    </div>
    </div>
  </div>



  <div class="container high-padding single-icondrops-tabs">

    <?php echo do_shortcode('[heading_title_subtitle title="'.$ico_replacement.esc_attr__(' Details', 'mtlisitings').'" subtitle="'.esc_attr__('View Details such as General, Token Supply
 & More', 'mtlisitings').'" align_title="text_center" title_color="custom_color" title_colorpicker="#252525" subtitle_color="custom_color" subtitle_colorpicker="#4f4f4f" animation="bounce" border_color="dark_border"][vc_empty_space height="40px"]'); ?>


    <div class="row main-row">
    <div class="col-md-5">

      <?php if (!empty($mt_listing_website_button) || !empty($mt_listing_whitepaper_button) || !empty($mt_listing_accepts) || !empty($mt_listing_ticker) || !empty($term_list[0]->name) || !empty($mt_listing_competition_coins) || !empty($mt_listing_prototype_url) || !empty($mt_listing_cant_participate) || !empty(get_the_content())) { ?>
      <div class="row ico-info">
        <div class="panel panel-single-icondrops">
          <div class="panel-body"><?php esc_html_e('General','mtlisitings'); ?>    </div>
        </div>

        <div class="single-icondrops-content">
          <?php if (!empty($mt_listing_website_button)) { ?>
          <div class="col-md-6">
            <h5><strong><?php esc_html_e('Website','mtlisitings'); ?></strong></h5>
            <p><a target="_blank" href="<?php echo esc_url($mt_listing_website_button); ?>"><?php esc_html_e('Link','mtlisitings'); ?></a></p>
          </div>
          <?php } ?>

          <?php if (!empty($mt_listing_prototype_url)) { ?>
          <div class="col-md-6">
            <h5><strong><?php esc_html_e('Prototype:','mtlisitings'); ?></strong></h5>
            <p><a target="_blank" href="<?php echo esc_url($mt_listing_prototype_url); ?>" ><?php esc_html_e('Link' ,'mtlisitings'); ?></a></p>
          </div>
          <?php } ?>

          <?php if (!empty($mt_listing_whitepaper_button)) { ?>
          <div class="col-md-6">
            <h5><strong><?php esc_html_e('Whitepaper','mtlisitings'); ?></strong></h5>
            <p><a target="_blank" href="<?php echo esc_url($mt_listing_whitepaper_button); ?>" ><?php esc_html_e('Link' ,'mtlisitings'); ?></a></p>
          </div>
          <?php } ?>

          <?php if (!empty($mt_listing_accepts)) { ?>
          <div class="col-md-6">
            <h5><strong><?php esc_html_e('Participation with:', 'mtlisitings'); ?></strong></h5>
            <p><?php echo esc_html($mt_listing_accepts); ?></p>
          </div>
          <?php } ?>

          <?php if (!empty($mt_listing_ticker)) { ?>
          <div class="col-md-6">
            <h5><strong><?php esc_html_e('Token Name:','mtlisitings'); ?></strong></h5>
            <p><?php echo esc_html($mt_listing_ticker); ?></p>
          </div>
          <?php } ?>

          <?php if (!empty($term_list[0]->name)) { ?>
          <div class="col-md-6">
            <h5><strong><?php esc_html_e('Category:','mtlisitings'); ?></strong></h5>
            <?php $term_list = wp_get_post_terms(get_the_ID(), 'mt-listing-category2'); ?> 
            <p><a href="<?php echo esc_url(get_term_link($term_list[0]->name, 'mt-listing-category2')); ?>"><?php echo esc_attr($term_list[0]->name); ?></a></p>
          </div>
          <?php } ?>

          <?php if (!empty($mt_listing_role_token)) { ?>
          <div class="col-md-6">
            <h5><strong><?php esc_html_e('Token Role:','mtlisitings'); ?></strong></h5>
            <p><?php echo esc_html($mt_listing_role_token); ?></p>
          </div>
          <?php } ?>

          <?php if (!empty($mt_listing_token_type)) { ?>
          <div class="col-md-6">
            <h5><strong><?php esc_html_e('Token Type:','mtlisitings'); ?></strong></h5>
            <p><?php echo esc_html($mt_listing_token_type); ?></p>
          </div>
          <?php } ?>

          <?php if (!empty($mt_listing_competition_coins)) { ?>
          <div class="col-md-6">
            <h5><strong><?php esc_html_e('Competition:','mtlisitings'); ?></strong></h5>
            <p><?php echo esc_html($mt_listing_competition_coins); ?></p>
          </div>
          <?php } ?>

          <?php if (!empty($mt_listing_cant_participate)) { ?>
          <div class="col-md-6">
            <h5><strong><?php esc_html_e('Can\'t participate:','mtlisitings'); ?></strong></h5>
            <p><?php echo esc_html($mt_listing_cant_participate); ?></p>
          </div>
          <?php } ?>

          <?php if (!empty($mt_listing_cant_participate)) { ?>
          <div class="col-md-6">
            <h5><strong><?php esc_html_e('Know Your Customer (KYC):','mtlisitings'); ?></strong></h5>
            <p><?php echo esc_html($mt_listing_kyc); ?></p>
          </div>
          <?php } ?>

          <?php if (!empty($mt_select_rating_star)) { ?>
          <div class="col-md-6">
            <h5><strong><?php esc_html_e('Rating:','mtlisitings'); ?></strong></h5>
            <p>
              <div class="mt-ico-rating">
                <div class="mt-ico-rating-empty"></div>
                <div class="mt-ico-rating-fill" style="width: <?php echo esc_attr($mt_select_rating_star); ?>"></div>
              </div>
            </p>
          </div>
          <?php } ?>

          <?php if (!empty(get_the_content())) { ?>
          <div class="col-md-12">
            <h5><strong><?php esc_html_e('About:','mtlisitings'); ?></strong></h5>
            <div class="list_description">
              <?php the_content(); ?>
            </div>
          </div>
          <?php } ?>

        </div>
      </div>
      <?php } ?>


      <?php if (!empty($mt_listing_facebook) || !empty($mt_listing_joinchat) || !empty($mt_listing_bitcointalk) || !empty($mt_listing_twitter) || !empty($mt_listing_github) || !empty($mt_listing_medium)) { ?>
      <div class="row ico-info">

        <div class="panel panel-single-icondrops">
          <div class="panel-body"><?php esc_html_e('Social Media','mtlisitings'); ?>    </div>
        </div>

        <div class="single-icondrops-content single-icondrops-content-socialmedia">
          <ul class="social-links">

            <?php if (!empty($mt_listing_facebook)) { ?>
              <li class="facebook">
                <a target="_blank" data-toggle="tooltip" title="<?php echo esc_attr__('Go to Facebook', 'mtlisitings'); ?>" href="<?php echo esc_url($mt_listing_facebook); ?>"><i class="fa fa-facebook"></i></a>
              </li>
            <?php } ?>

            <?php if (!empty($mt_listing_linkedin)) { ?>
              <li class="linkedin">
                <a target="_blank" data-toggle="tooltip" title="<?php echo esc_attr__('Go to LinkedIn', 'mtlisitings'); ?>" href="<?php echo esc_url($mt_listing_linkedin); ?>"><i class="fa fa-linkedin"></i></a>
              </li>
            <?php } ?>

            <?php if (!empty($mt_listing_joinchat)) { ?>
              <li class="telegram">
                <a target="_blank" data-toggle="tooltip" title="<?php echo esc_attr__('Go to Telegram', 'mtlisitings'); ?>" data-placement="top" href="<?php echo esc_url($mt_listing_joinchat); ?>"><i class="fa fa-telegram"></i></a>
              </li>
            <?php } ?>

            <?php if (!empty($mt_listing_bitcointalk)) { ?>
              <li class="bitcointalk">
                <a target="_blank" data-toggle="tooltip" title="<?php echo esc_attr__('Go to BitcoinTalk', 'mtlisitings'); ?>" data-placement="top" href="<?php echo esc_url($mt_listing_bitcointalk); ?>"><i class="fa fa-btc"></i></a>
              </li>
            <?php } ?>

                  <?php if (!empty($mt_listing_twitter)) { ?>
              <li class="twitter">
                <a target="_blank" data-toggle="tooltip" title="<?php echo esc_attr__('Go to Twitter', 'mtlisitings'); ?>" data-placement="top" href="<?php echo esc_url($mt_listing_twitter); ?>"><i class="fa fa-twitter"></i></a>
              </li>
            <?php } ?>

            <?php if (!empty($mt_listing_github)) { ?>
              <li class="github">
                <a target="_blank" data-toggle="tooltip" title="<?php echo esc_attr__('Go to GitHub', 'mtlisitings'); ?>" data-placement="top" href="<?php echo esc_url($mt_listing_github); ?>"><i class="fa fa-github"></i></a>
              </li>
            <?php } ?>

            <?php if (!empty($mt_listing_medium)) { ?>
              <li class="medium">
                <a target="_blank" data-toggle="tooltip" title="<?php echo esc_attr__('Go to Medium', 'mtlisitings'); ?>" data-placement="top" href="<?php echo esc_url($mt_listing_medium); ?>"><i class="fa fa-medium"></i></a>
              </li>
            <?php } ?>

            <?php if (!empty($mt_listing_youtube)) { ?>
              <li class="youtube">
                <a target="_blank" data-toggle="tooltip" title="<?php echo esc_attr__('Go to YouTube', 'mtlisitings'); ?>" data-placement="top" href="<?php echo esc_url($mt_listing_youtube); ?>"><i class="fa fa-youtube-play"></i></a>
              </li>
            <?php } ?>
           </ul>
        </div>
      </div>
      <?php } ?>
    </div>

    <div class="col-md-7">
      <?php if (!empty($mt_video_tour)) { ?>
      <div class="row ico-info">
        <div class="panel panel-single-icondrops">
          <div class="panel-body"><?php esc_html_e('Video Presentation','mtlisitings'); ?>    </div>
        </div>

        <div class="row middle-desk">
            <div class="col-md-12">
              <div class="mt_listing--youtube_video">                 
                <div class="mt_listing--youtube_video">
                  <?php if ($mt_listing_style == 'light') { ?>
                    <img alt="<?php echo esc_attr__('Video', 'mtlisitings'); ?>" src="<?php echo plugins_url(); ?>/modeltheme-listings-manager/inc/templates/images/light_video_bg.jpg">
                    <a class="popup-vimeo-youtube popup-play-video" href="<?php echo esc_attr($mt_video_tour); ?>" data-src=""><img alt="<?php echo esc_attr__('Video Button', 'mtlisitings'); ?>" src="<?php echo plugins_url(); ?>/modeltheme-listings-manager/inc/templates/images/play-button_dark.png"></a>                  
                  <?php } else { ?> 
                     <img alt="<?php echo esc_attr__('Video', 'mtlisitings'); ?>" src="<?php echo plugins_url(); ?>/modeltheme-listings-manager/inc/templates/images/video_bg.jpg">
                     <a class="popup-vimeo-youtube popup-play-video" href="<?php echo esc_attr($mt_video_tour); ?>" data-src=""><img alt="<?php echo esc_attr__('Video Button', 'mtlisitings'); ?>" src="<?php echo   plugins_url(); ?>/modeltheme-listings-manager/inc/templates/images/play-button_white.png"></a>
                  <?php } ?>
                </div>                                   
              </div>
            </div>
        </div> 
      </div>
      <?php } ?>

      <div class="row ico-info">
        <div class="panel panel-single-icondrops">
          <div class="panel-body"><?php esc_html_e('Token Supply','mtlisitings'); ?>    </div>
        </div>

        <div class="single-icondrops-content">
          <?php if (!empty($mt_listing_fundraising_goal)){ ?>
          <div class="col-md-6">
            <h5><strong><?php esc_html_e('Fundraising Goal:','mtlisitings'); ?></strong></h5>
            <p>
              <?php 
                if (numismatico_redux('mt_listings_settings_currency_position') == 'left') {
                    echo mtlisitings_get_currency_symbol();
                }elseif (numismatico_redux('mt_listings_settings_currency_position') == 'left_with_space') {
                    echo mtlisitings_get_currency_symbol() . ' ';
                }

                echo esc_html(number_format(preg_replace("/[^0-9]/", "", $mt_listing_fundraising_goal), 0, ',', '.'));
                if (numismatico_redux('mt_listings_settings_currency_position') == 'right') {
                    echo mtlisitings_get_currency_symbol();
                }elseif (numismatico_redux('mt_listings_settings_currency_position') == 'right_with_space') {
                    echo ' ' . mtlisitings_get_currency_symbol();
                }
              ?>
            </p>
          </div>
          <?php } ?>

          <?php if (!empty($mt_listing_sold_on_pre_sale)){ ?>
          <div class="col-md-6">
            <h5><strong><?php esc_html_e('Sold on Pre-Sale:','mtlisitings'); ?></strong></h5>
            <p>
            <?php 
              if (numismatico_redux('mt_listings_settings_currency_position') == 'left') {
                  echo mtlisitings_get_currency_symbol();
              }elseif (numismatico_redux('mt_listings_settings_currency_position') == 'left_with_space') {
                  echo mtlisitings_get_currency_symbol() . ' ';
              }
              echo esc_html(number_format(preg_replace("/[^0-9]/", "", $mt_listing_sold_on_pre_sale), 0, ',', '.'));
              if (numismatico_redux('mt_listings_settings_currency_position') == 'right') {
                  echo mtlisitings_get_currency_symbol();
              }elseif (numismatico_redux('mt_listings_settings_currency_position') == 'right_with_space') {
                  echo ' ' . mtlisitings_get_currency_symbol();
              }
            ?>
            </p>
          </div>      
          <?php } ?>

          <?php if (!empty($mt_listing_total_tokens) || !empty($mt_listing_ticker)){ ?>
          <div class="col-md-6">
            <h5><strong><?php esc_html_e('Total Supply:','mtlisitings'); ?></strong></h5>
            <p><?php echo esc_html(number_format(preg_replace("/[^0-9]/", "", $mt_listing_total_tokens), 0, ',', '.')); ?> <?php echo esc_html($mt_listing_ticker); ?> </p>
          </div>
          <?php } ?>

          <?php if (!empty($mt_listing_available_for_token_sale)){ ?>
          <div class="col-md-6">
            <h5><strong><?php esc_html_e('Circulating Supply:','mtlisitings'); ?></strong></h5>
            <p><?php echo esc_html(number_format(preg_replace("/[^0-9]/", "", $mt_listing_available_for_token_sale), 0, ',', '.')); ?> <?php echo esc_html($mt_listing_ticker); ?></p>
          </div>
          <?php } ?>

          <?php if (!empty($mt_listing_team_tokens)){ ?>
          <div class="col-md-6">
            <h5><strong><?php esc_html_e('Team:','mtlisitings'); ?></strong></h5>
            <p><?php echo esc_html(number_format(preg_replace("/[^0-9]/", "", $mt_listing_team_tokens), 0, ',', '.')); ?> <?php echo esc_html($mt_listing_ticker); ?></p>
          </div>
          <?php } ?>

          <?php if (!empty($mt_listing_other_tokens)){ ?>
          <div class="col-md-6">
            <h5><strong><?php esc_html_e('Other:','mtlisitings'); ?></strong></h5>
            <p><?php echo esc_html(number_format(preg_replace("/[^0-9]/", "", $mt_listing_other_tokens), 0, ',', '.')); ?> <?php echo esc_html($mt_listing_ticker); ?></p>
          </div>
          <?php } ?>

          <?php if (!empty($mt_listing_sold_on_pre_sale) || !empty($mt_listing_fundraising_goal)){
            $sold_to_public = (((preg_replace("/[^0-9]/", "", $mt_listing_sold_on_pre_sale)) / (preg_replace("/[^0-9]/", "", $mt_listing_fundraising_goal))) * 100);
          ?>
          <div class="col-md-12">
            <h5><strong><?php esc_html_e('Tokens sold to the public','mtlisitings'); ?></strong> 
              <span class="skill">
                <i class="val"><?php echo esc_html(number_format($sold_to_public, 2)) . '%' ; ?></i>
              </span>
            </h5>
            <div class="progress skill-bar">
              <div class="progress-bar progress-bar-warning" role="progressbar" aria-valuenow="<?php echo esc_attr($sold_to_public); ?>" aria-valuemin="0" aria-valuemax="100" style="width:<?php echo esc_attr($sold_to_public); ?>%"></div>
            </div>
          </div>
          <?php } ?>

          <?php if (!empty($mt_listing_available_for_token_sale) || !empty($mt_listing_total_tokens)){
          $percentage = (((preg_replace("/[^0-9]/", "", $mt_listing_available_for_token_sale)) / (preg_replace("/[^0-9]/", "", $mt_listing_total_tokens))) * 100); 
          ?>
          <div class="col-md-12">
            <h5><strong><?php esc_html_e('Tokens in circulation after ','mtlisitings').$ico_replacement; ?></strong>
              <span class="skill">
                <i class="val"><?php echo esc_attr(number_format($percentage, 2)) . '%' ; ?></i>
              </span>
            </h5>
            <div class="progress skill-bar margin-bottom-10">
              <div class="progress-bar progress-bar-warning" role="progressbar" aria-valuenow="<?php echo esc_attr(number_format($percentage, 2)); ?>" aria-valuemin="0" aria-valuemax="100" style="width:<?php echo esc_attr($percentage); ?>%"></div>
            </div>
          </div>
          <?php } ?>

        </div>
      </div>
    </div>

    <div class="col-md-12 single-icondrops-adplace-bottom">

      <?php if (numismatico_redux('mt_adplace_single')) {
        if(numismatico_redux('mt_adplace_single_adsense_code') != '' && numismatico_redux('mt_adplace_single') == 'on_adsense'){
          echo numismatico_redux('mt_adplace_single_adsense_code');
        }elseif(numismatico_redux('mt_adplace_single_bottom_img','url') != '' && numismatico_redux('mt_adplace_single') == 'on'){ ?>
          <div class="single-icondrops-adplace-bottom-content">
                          <a href="<?php echo esc_url(numismatico_redux('mt_adplace_single_bottom_link')) ?>" target="_blank">
                              <img src="<?php echo esc_url(numismatico_redux('mt_adplace_single_bottom_img','url')) ?>" alt="" />
                          </a>
                  </div>
        <?php }
      } ?>

    </div>

    <?php 
      global  $dynamic_featured_image;
      $featured_images = $dynamic_featured_image->get_featured_images( get_the_ID() ); 
    ?>
    <?php if (!empty($featured_images)) { ?>
    <div class="col-md-12">
     <div class="row ico-info">
      <div class="panel panel-single-icondrops">
        <div class="panel-body"><?php esc_html_e('Images','mtlisitings'); ?>    </div>
      </div>
      <div class="mt_listing--gallery text-center single-icondrops-content">
            <?php
                $photos_number = '0';
                if( !is_null($featured_images) ){
                    $photos_number = count($featured_images);
                }
                $final_photos_number = $photos_number + 1;
            ?>
            <?php
                if( !is_null($featured_images) ){
                  $medias = array();
                  foreach($featured_images as $images){
                      $attachment_id = $images['attachment_id'];
                      $medias[] = $attachment_id;
                  }
                  $ids = '';
                  $len = count($medias);
                  $i = 0;
                  if ($medias) {
                    foreach($medias as $media){
                      $multiple_featured_image1 = wp_get_attachment_url( $media, 'full' );
                      echo '<div class="col-md-2">';
                        echo '<a class="mt_listing--single-gallery" href="'.esc_url($multiple_featured_image1).'">';
                          echo '<div class="ico-screenshot">';
                            echo '<img alt="'.esc_attr__('Gallery','mtlisitings').esc_attr($i).'" src="'.esc_url($multiple_featured_image1).'">'; 
                            echo '<div class="flex-zone">';
                            
                              echo '<span class="flex-zone-inside view-image-btn btn"><i class="fa fa-search" aria-hidden="true"></i></span>';
                            
                            echo '</div>';
                          echo '</div>';
                        echo '</a>';
                      echo '</div>';
                    }
                  }
                } 
            ?>
       </div>  
      </div>
      <?php } ?> 
    </div>
  </div>
</div>




  <div class="row single-icondrops-related-listings">
    <div class="container main-content">
      <div class="row ico-info">
       <div class="col-md-12">
        <?php if ( numismatico_redux('mt_related_listings') ) { ?>

          <?php echo do_shortcode('[heading_title_subtitle title="'.esc_attr__('Related ', 'mtlisitings').$ico_replacement_plural.'" subtitle="'.esc_attr__('View other interesting ', 'mtlisitings').$ico_replacement_plural.'" align_title="text_center" title_color="custom_color" title_colorpicker="#252525" subtitle_color="custom_color" subtitle_colorpicker="#4f4f4f" animation="bounce" border_color="dark_border"][vc_empty_space height="40px"]'); ?>

          <div class="col-md-12 main-content">
            <div class="row">
              <div class="clearfix"></div>
              <div class="posts-listings">
                <?php
                global  $post;  
                $orig_post = $post;  
                ?>
                <div class="row">
                  <?php 
                  $args=array(  
                      'post__not_in'          => array($post->ID),  
                      'posts_per_page'        => 6, // Number of related posts to display.  
                      'post_type'             => 'mt_listing',
                      'post_status'           => 'publish',
                      'ignore_sticky_posts'   => 1  
                  );
                  $my_query = new wp_query( $args );
                  while( $my_query->have_posts() ) {  
                    $my_query->the_post(); 
                
                    $mt_listing_category_recent = get_post_meta( get_the_ID(), 'mt_listing_category', true ); 
                    $mt_listing_received_recent = get_post_meta( get_the_ID(), 'mt_listing_received', true );
                    $mt_listing_fundraising_goal_recent = get_post_meta( get_the_ID(), 'mt_listing_fundraising_goal', true );
                    $mt_listing_received_percentage_recent = get_post_meta( get_the_ID(), 'mt_listing_received_percentage', true );
                    $mt_listing_interest_recent = get_post_meta( get_the_ID(), 'mt_listing_interest', true );
                    $mt_listing_end_date_pick = get_post_meta( get_the_ID(), 'mt_listing_end_date_pick', true );
                    $mt_select_font = get_post_meta( get_the_ID(), 'mt_select_font', true );
                    $mt_font_cryptocoins_icons = get_post_meta( get_the_ID(), 'mt_font_cryptocoins_icons', true );
                    $mt_font_awesome_icons = get_post_meta( get_the_ID(), 'mt_font_awesome_icons', true );
                    $mt_font_simple_line = get_post_meta( get_the_ID(), 'mt_font_simple_line_icons', true );
                    $mt_listing_ticker_related_listings = get_post_meta( get_the_ID(), 'mt_listing_ticker', true );
                    $mt_listing_sponsored_status = get_post_meta( $post->ID, 'mt_listing_sponsored_status', true );
                    $term_list = wp_get_post_terms($post->ID, 'mt-listing-category');
                    // var_dump($term_list);
                    $term_list_categories = wp_get_post_terms($post->ID, 'mt-listing-category2');

                    // TAXONOMY PHOTO/ICON
                    $taxonomy_image_id = get_term_meta ( $term_list_categories[0]->term_id, 'category-image-id', true );
                    $tax_img = '';
                    if (wp_get_attachment_image ( $taxonomy_image_id, 'thumbnail' )) {
                      $tax_img = wp_get_attachment_image ( $taxonomy_image_id, 'thumbnail' );
                    }
                    $my_excerpt = get_the_excerpt( $post->ID); 

                    // COMPARE DATES
                    $mt_listing_end_date_pick_new_format = date('Y-m-d H:i:s', strtotime($mt_listing_end_date_pick));
                    $todaydate = date("Y-m-d H:i:s");

                    if($todaydate > $mt_listing_end_date_pick_new_format){
                      $end_label = esc_html__('Ended: ' ,'mtlisitings') . date('M m, Y', strtotime($mt_listing_end_date_pick));
                    }else{
                      $end_label = date('M m, Y', strtotime($mt_listing_end_date_pick));
                    }
                    ?>

                    <?php $sticky_class = '';
                    if ( is_sticky(get_the_ID()) ) {
                        $sticky_class = 'is-sticky';
                    }  ?>

                    <div class="col-md-6 post">
                      <div class="ico-info">
                        <div class="blog_custom_listings <?php echo esc_attr($sticky_class); ?> <?php echo esc_attr($mt_listing_sponsored_status); ?>">
                            <?php if ((isset($sticky_class) && !empty($sticky_class)) || (isset($mt_listing_sponsored_status) && !empty($mt_listing_sponsored_status))) { ?>
                            <div class="event-box-corner"></div>
                            <?php } ?>
                            <?php $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID )); ?>
                            <div class="row">
                              <!-- Image -->
                              <div class="col-md-2">
                                <?php if (!empty($thumbnail_src)) { ?>
                                  <a href="<?php the_permalink(); ?>" class="relative">
                                      <?php if($thumbnail_src) { ?>
                                          <img src="<?php echo esc_attr($thumbnail_src[0]); ?>" class="img-responsive" alt="<?php the_title(); ?>" />
                                      <?php } ?>
                                  </a>
                                <?php } else { ?>
                                  <div class="featured-icon">
                                    
                                    <?php if (isset($mt_select_font) && $mt_select_font == 'cryptocoins_icons') { ?>
                                      <?php if($mt_font_cryptocoins_icons) { ?>
                                        <i class="<?php echo esc_attr($mt_font_cryptocoins_icons); ?>"></i>
                                      <?php } ?>
                                    <?php } elseif (isset($mt_select_font) && $mt_select_font == 'font_awesome_icons') { ?>
                                      <?php if($mt_font_awesome_icons) { ?>
                                        <i class="<?php echo esc_attr($mt_font_awesome_icons); ?>"></i>
                                      <?php } ?>
                                    <?php } elseif (isset($mt_select_font) && $mt_select_font == 'simple_line_icons') { ?>
                                      <?php if($mt_font_simple_line) { ?>
                                        <i class="<?php echo esc_attr($mt_font_simple_line); ?>"></i>
                                      <?php } ?>
                                    <?php } ?>
                                  </div>
                                <?php } ?>
                              </div>
                              <!-- title/content -->
                              <div class="col-md-10">
                                <h4 class="post-name-listings">
                                  <a href="<?php the_permalink(); ?>">
                                    <?php the_title(); ?>
                                    <span>
                                      <i class="fa fa-calendar-times-o"></i><?php echo $end_label; ?>
                                    </span>
                                  </a>
                                </h4>
                                <p class="numismatico-details-content"><?php echo strip_tags(mtlisitings_excerpt_limit($my_excerpt, 10)); ?>(...)</p>
                              </div>
                            </div>
                            <div class="listings_details">                                
                              <div class="numismatico-metas">
                                <?php $term_list = wp_get_post_terms(get_the_ID(), 'mt-listing-category'); ?> 

                                <?php if (!empty($term_list)) { ?>
                                  <div class="numismatico-metas-single-meta pull-left ico-type">
                                    <?php if (!empty($term_list[0]->name)) { ?>
                                      <div><i class="fa fa-check-circle"></i> <?php echo esc_attr($term_list[0]->name); ?></div>
                                    <?php } ?>
                                  </div>
                                <?php } ?>

                                <div class="numismatico-metas-single-meta pull-left ico-category">
                                  <?php $term_list_categories = wp_get_post_terms(get_the_ID(), 'mt-listing-category2'); ?> 
                                  <?php if (!empty($term_list_categories[0]->name)) { ?>
                                    <div><?php echo $tax_img; ?><?php echo esc_attr($term_list_categories[0]->name); ?></div>
                                  <?php } ?>
                                </div>

                              </div>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                      </div>
                    </div>
                  <?php } ?>
                </div>
              </div>
              <?php 
                $post = $orig_post;  
                wp_reset_postdata();  
              ?>  
            </div> <!-- row -->
          </div>
      </div>
<?php } ?>
      </div>
    </div>
  </div>
</article>